% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/default-credential.R
\name{get_request_authorizer}
\alias{get_request_authorizer}
\title{Get Default Request Authorizer Function}
\usage{
get_request_authorizer(
  scope = NULL,
  tenant_id = NULL,
  client_id = NULL,
  client_secret = NULL,
  use_cache = "disk",
  offline = TRUE,
  chain = default_credential_chain()
)
}
\arguments{
\item{scope}{Optional character string specifying the authentication scope.}

\item{tenant_id}{Optional character string specifying the tenant ID for
authentication.}

\item{client_id}{Optional character string specifying the client ID for
authentication.}

\item{client_secret}{Optional character string specifying the client secret
for authentication.}

\item{use_cache}{Character string indicating the caching strategy. Defaults
to \code{"disk"}. Options include \code{"disk"} for disk-based caching or \code{"memory"}
for in-memory caching.}

\item{offline}{Logical. If \code{TRUE}, adds 'offline_access' to the scope to request a 'refresh_token'.
Defaults to \code{TRUE}.}

\item{chain}{A list of credential objects, where each element must inherit
from the \code{Credential} base class. Credentials are attempted in the order
provided until \code{get_token} succeeds.}
}
\value{
A function that authorizes HTTP requests with appropriate credentials
when called.
}
\description{
Creates a request authorizer function that retrieves authentication credentials
and returns a callable request authorization method. This function handles the
credential discovery process and returns the request authentication method
from the discovered credential object.
}
\examples{
# In non-interactive sessions, this function will return an error if the
# environment is not setup with valid credentials. And in an interactive session
# the user will be prompted to attempt one of the interactive authentication flows.
\dontrun{
req_auth <- get_request_authorizer(
  scope = "https://graph.microsoft.com/.default"
)
req <- req_auth(httr2::request("https://graph.microsoft.com/v1.0/me"))
}

}
\seealso{
\code{\link[=get_token_provider]{get_token_provider()}}, \code{\link[=get_token]{get_token()}}
}
