% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{popedGetMultipleEndpointModelingTimes}
\alias{popedGetMultipleEndpointModelingTimes}
\alias{popedMultipleEndpointIndexDataFrame}
\title{Get Multiple Endpoint Modeling Times}
\usage{
popedGetMultipleEndpointModelingTimes(times, modelSwitch, sorted = FALSE)

popedMultipleEndpointIndexDataFrame(print = FALSE)
}
\arguments{
\item{times}{A numeric vector of times.}

\item{modelSwitch}{An integer vector of model switch indicator
corresponding to the times}

\item{sorted}{A boolean indicating if the returned times should be sorted}

\item{print}{boolean for \code{popedMultipleEndpointIndexDataFrame()}
when \code{TRUE} show each id/index per time even though it may not
reflect in the returned data.frame}
}
\value{
A numeric vector of unique times.
}
\description{
This function takes a vector of times and a corresponding vector
of IDs, groups the times by their IDs, initializes an internal
C++ global TimeIndexer, that is used to efficiently lookup the
final output from the rxode2 solve and then returns the sorted
unique times.

The \code{popedMultipleEndpointIndexDataFrame()} function can be used
to visualize the internal data structure inside R, but it does
not show all the indexes in the case of time ties for a given
ID.  Rather it shows one of the indexs and the total number of
indexes in the data.frame
}
\examples{


\donttest{

times <- c(1.1, 1.2, 1.3, 2.1, 2.2, 3.1)
modelSwitch <- c(1, 1, 1, 2, 2, 3)
sortedTimes <- popedGetMultipleEndpointModelingTimes(times, modelSwitch, TRUE)
print(sortedTimes)

# now show the output of the data frame representing the model
# switch to endpoint index

popedMultipleEndpointIndexDataFrame()

# now show a more complex example with overlaps etc.

times <- c(1.1, 1.2, 1.3, 0.5, 2.2, 1.1, 0.75,0.75)
modelSwitch <- c(1, 1, 1, 2, 2, 2, 3, 3)
sortedTimes <- popedGetMultipleEndpointModelingTimes(times, modelSwitch, TRUE)
print(sortedTimes)

popedMultipleEndpointIndexDataFrame(TRUE) # Print to show individual matching

}
}
