% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bage_ssvd-methods.R
\name{generate.bage_ssvd}
\alias{generate.bage_ssvd}
\title{Generate Random Age or Age-Sex Profiles}
\usage{
\method{generate}{bage_ssvd}(
  x,
  v = NULL,
  n_draw = 20,
  n_comp = NULL,
  indep = NULL,
  age_labels = NULL,
  ...
)
}
\arguments{
\item{x}{An object of class \code{"bage_ssvd"}.}

\item{v}{Version of data to use.}

\item{n_draw}{Number of random draws to generate.}

\item{n_comp}{The number of components.
The default is half the total number of
components of \code{object}.}

\item{indep}{Whether to use independent or
joint SVDs for each sex/gender, if the
data contains a sex/gender variable.
The default is to use independent SVDs.
To obtain results for the total population
when the data contains a sex/gender variable,
set \code{indep} to \code{NA}.}

\item{age_labels}{Age labels for the
desired age or age-sex profile.
If no labels are supplied, the
most detailed profile available is used.}

\item{...}{Unused. Included for generic consistency only.}
}
\value{
A tibble
}
\description{
Generate random age or age-sex profiles from
an object of class \code{"bage_ssvd"}. An object
of class \code{"bage_ssvd"} holds results from
an \link[base:svd]{SVD} decomposition of demographic
data.
}
\section{Scaled SVDs of demographic databases in bage}{

\itemize{
\item \code{\link{HMD}} Mortality rates from the
\href{https://www.mortality.org}{Human Mortality Database}.
\item \code{\link{HFD}} Fertility rates from the
\href{https://www.humanfertility.org}{Human Fertility Database}.
\item \code{\link{LFP}} Labor forcce participation
rates from the \href{https://data-explorer.oecd.org}{OECD}.
}
}

\examples{
## females and males modeled independently
generate(HMD) 

## joint model for females and males
generate(HMD, indep = FALSE) 

## SVD for females and males combined
generate(HMD, indep = NA)

## specify age groups
labels <- poputils::age_labels(type = "lt", max = 60)
generate(HMD, age_labels = labels)
}
\seealso{
\itemize{
\item \link[=components]{components()} Components
used by SVD prior.
\item \code{\link[=SVD]{SVD()}} SVD prior for term involving age.
\item \code{\link[=SVD_AR1]{SVD_AR1()}}, \code{\link[=SVD_AR]{SVD_AR()}}, \code{\link[=SVD_RW]{SVD_RW()}}, \code{\link[=SVD_RW2]{SVD_RW2()}}
Dynamic SVD priors for terms involving age and time.
\item \code{\link[poputils:age_labels]{poputils::age_labels()}} Generate age labels.
}
}
