% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nplcm.R
\name{init_latent_jags_multipleSS}
\alias{init_latent_jags_multipleSS}
\title{Initialize individual latent status (for \code{JAGS})}
\usage{
init_latent_jags_multipleSS(
  MSS_list,
  cause_list,
  patho = unlist(lapply(MSS_list, colnames))
)
}
\arguments{
\item{MSS_list}{A list of silver-standard measurement data, possibly with more than one
slices; see \code{data_nplcm} argument in \code{\link[=nplcm]{nplcm()}}}

\item{cause_list}{See \code{model_options} arguments in \code{\link[=nplcm]{nplcm()}}}

\item{patho}{A vector of measured pathogen name for \code{MSS};
default is \code{colnames(MSS)}}
}
\value{
a list of numbers, indicating categories of individual latent causes.
}
\description{
Initialize individual latent status (for \code{JAGS})
}
\details{
In \code{JAGS} 3.4.0, if an initial value contradicts the probabilistic specification, e.g.
\code{MSS_1[i,j] ~ dbern(mu_ss_1[i,j])}, where \code{MSS_1[i,j]=1} but \code{mu_ss_1[i,j]=0},
then \code{JAGS} cannot understand it. In PERCH application, this is most likely used when the specificity of the
silver-standard data is \code{1}. Note: this is not a problem in \code{WinBUGS}.
}
\concept{initialization functions}
