% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/biomod2_classes_0.R
\docType{class}
\name{BIOMOD.options.dataset}
\alias{BIOMOD.options.dataset}
\alias{BIOMOD.options.dataset-class}
\alias{BIOMOD.options.dataset,character-method}
\alias{show,BIOMOD.options.dataset-method}
\alias{print,BIOMOD.options.dataset-method}
\title{\code{\link{bm_ModelingOptions}} output object class}
\usage{
\S4method{BIOMOD.options.dataset}{character}(
  mod,
  typ,
  pkg,
  fun,
  strategy,
  user.val = NULL,
  user.base = NULL,
  tuning.fun = NULL,
  bm.format = NULL,
  calib.lines = NULL
)

\S4method{show}{BIOMOD.options.dataset}(object)

\S4method{print}{BIOMOD.options.dataset}(x, dataset = "_allData_allRun")
}
\arguments{
\item{mod}{a \code{character} corresponding to the model name to be computed, must be either 
\code{ANN}, \code{CTA}, \code{DNN}, \code{FDA}, \code{GAM}, \code{GBM}, \code{GLM}, \code{MARS}, 
\code{MAXENT}, \code{MAXNET}, \code{RF}, \code{SRE}, \code{XGBOOST}}

\item{typ}{a \code{character} corresponding to the data type to be used, must be either 
\code{binary}, \code{binary.PA}, \code{abundance}, \code{compositional}}

\item{pkg}{a \code{character} corresponding to the package containing 
the model function to be called}

\item{fun}{a \code{character} corresponding to the model function name 
to be called}

\item{strategy}{a \code{character} corresponding to the method to 
select models' parameters values, must be either \code{default}, 
\code{bigboss}, \code{user.defined}, \code{tuned}}

\item{user.val}{(\emph{optional, default} \code{NULL}) \cr
A \code{list} containing parameters values}

\item{user.base}{(\emph{optional, default} \code{NULL}) \cr A character, 
\code{default} or \code{bigboss} used when \code{strategy = 'user.defined'}. 
It sets the bases of parameters to be modified by user defined values.}

\item{tuning.fun}{(\emph{optional, default} \code{NULL}) \cr
A \code{character} corresponding to the model function name 
to be called through \code{\link[caret]{train}} function for tuning parameters}

\item{bm.format}{(\emph{optional, default} \code{NULL}) \cr
A \code{\link{BIOMOD.formated.data}} or \code{\link{BIOMOD.formated.data.PA}} 
object returned by the \code{\link{BIOMOD_FormatingData}} function}

\item{calib.lines}{(\emph{optional, default} \code{NULL}) \cr
A \code{data.frame} object returned by \code{\link{get_calib_lines}} or 
\code{\link{bm_CrossValidation}} functions, to explore the distribution of calibration 
and validation datasets}

\item{object}{a \code{\link{BIOMOD.options.dataset}} object}

\item{x}{a \code{\link{BIOMOD.options.dataset}} object}

\item{dataset}{a \code{character} corresponding to the name of a dataset contained 
in the \code{arg.values} slot}
}
\description{
Class returned by \code{\link{bm_ModelingOptions}} (a 
\code{list} of \code{BIOMOD.options.dataset} more exactly), and used by 
\code{\link{BIOMOD_Modeling}}
}
\section{Slots}{

\describe{
\item{\code{model}}{a \code{character} corresponding to the model}

\item{\code{type}}{a \code{character} corresponding to the data type 
(\code{binary}, \code{binary.PA}, \code{abundance}, \code{compositional})}

\item{\code{package}}{a \code{character} corresponding to the package containing 
the model function to be called}

\item{\code{func}}{a \code{character} corresponding to the model function name 
to be called}

\item{\code{args.names}}{a \code{vector} containing \code{character} corresponding 
to the model function arguments}

\item{\code{args.default}}{a \code{list} containing for each dataset the default 
values for all arguments listed in \code{args.names}}

\item{\code{args.values}}{a \code{list} containing for each dataset the to-be-used
values for all arguments listed in \code{args.names}}
}}

\examples{

showClass("BIOMOD.options.dataset")


}
\seealso{
\code{\link{BIOMOD.options.default}}, \code{\link{bm_ModelingOptions}}, 
\code{\link{bm_Tuning}}, \code{\link{BIOMOD_Modeling}}, \code{\link{bm_RunModelsLoop}}

Other Toolbox objects: 
\code{\link{BIOMOD.ensemble.models.out}},
\code{\link{BIOMOD.formated.data}},
\code{\link{BIOMOD.formated.data.PA}},
\code{\link{BIOMOD.models.options}},
\code{\link{BIOMOD.models.out}},
\code{\link{BIOMOD.options.default}},
\code{\link{BIOMOD.projection.out}},
\code{\link{BIOMOD.rangesize.out}},
\code{\link{BIOMOD.stored.data}},
\code{\link{biomod2_ensemble_model}},
\code{\link{biomod2_model}}
}
\author{
Maya Guéguen
}
\concept{Toolbox objects}
