% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/count_edges.R
\name{Count Edges}
\alias{Count Edges}
\alias{count_homologous}
\alias{count_inter}
\title{Count number of edges of a brain graph}
\usage{
count_homologous(g)

count_inter(g, group = c("lobe", "hemi", "network", "class", "gyrus",
  "Yeo_7network", "Yeo_17network", "area", "Brodmann"))
}
\arguments{
\item{g}{A \code{brainGraph} graph object}

\item{group}{Character string specifying which grouping to calculate edge
counts for. Default: \code{'lobe'}}
}
\value{
\code{count_homologous} - a named vector of the edge ID's connecting
  homologous regions

\code{count_inter} - a \code{data.table} of total, intra-, and
  inter-group edge counts
}
\description{
\code{count_homologous} counts the number of edges between homologous regions
in a brain graph (e.g. between L and R superior frontal).

\code{count_inter} counts the number of edges between and within all vertices
in one group (e.g. \emph{lobe}, \emph{hemi}, \emph{network}, etc.).
}
\examples{
\dontrun{
g1.lobecounts <- count_inter(g[[1]][[N]], 'lobe')
}
}
\author{
Christopher G. Watson, \email{cgwatson@bu.edu}
}
