% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/import.R
\name{import_scn}
\alias{import_scn}
\title{Import data for structural connectivity analysis}
\usage{
import_scn(datadir, atlas, modality = "thickness", exclude.subs = NULL,
  custom.atlas = NULL)
}
\arguments{
\item{datadir}{The path name of the directory containing the data files}

\item{atlas}{Character string specifying the atlas in use. For a custom
atlas, please specify \code{'custom'}, and provide the name to the
\code{custom.atlas} argument}

\item{modality}{The structural imaging measure (default: \code{'thickness'})}

\item{exclude.subs}{Vector indicating the subjects to exclude, if any
(default: \code{NULL})}

\item{custom.atlas}{Character string specifying the name of the R object for
the atlas in use, if \code{atlas='custom'} was also supplied (default:
\code{NULL})}
}
\value{
A list containing:
  \item{atlas}{Character string}
  \item{modality}{Character string}
  \item{lhrh}{A \code{data.table} of structural MRI measures for both
    hemispheres}
  \item{aseg}{A \code{data.table} of structural MRI measures for subcortical
    gray matter, if applicable}
  \item{subs.excluded}{Vector of subject ID's that were excluded}
  \item{subs.missing}{Vector of subject ID's that are not present in \emph{both}
    the cortical and subcortical tables (if applicable)}
}
\description{
Given a directory, atlas name, and imaging modality/structural metric, this
function imports data for structural connectivity analysis. It expects files
containing a table of region-wise structural MRI measures (e.g., mean
cortical thickness), with one file for each hemisphere. The first column of
all files should contain the \emph{subject ID}; the column name will be
changed to the value of \code{getOption('bg.subject_id')}.
}
\details{
The files should have specific names; the second in the following list is
only required for atlases/parcellations that include \emph{subcortical gray
matter} (e.g., \code{dk.scgm}).
\itemize{
  \item \code{${parcellation}_${hemi}_${modality}.csv} for cortical volume,
    thickness, surface area, or local gyrification index (LGI). Here,
    \code{${parcellation}} can be \code{aparc}, \code{aparc.DKTatlas40},
    or \code{aparc.a2009s}. For example, for cortical thickness with the
    \emph{Desikan-Killiany} atlas, the filename should be
    \code{aparc_lh_thickness.csv}. If you are using a custom atlas, see the
    \emph{Note} below. The \code{${hemi}} variable is either \code{lh} or
    \code{rh}. Finally, \code{${modality}} should be either \code{volume},
    \code{thickness}, \code{area}, or \code{lgi}.
  \item \code{asegstats.csv} for SCGM volume
}
}
\note{
When using a custom atlas, the name of the atlas's data.table should
  match the \code{${parcellation}} portion of the filename (specification
  shown above). Furthermore, it must conform to the output of Freesurfer's
  \code{aparcstats2table} (and \code{asegstats2table}, if applicable).
  Otherwise, please contact me for inclusion of a different data type.

The subject ID column will be zero-padded (to the left) to avoid issues
  when the variable is numeric; this ensures that all ID's will have the same
  number of characters and sorting will be done properly.
}
\examples{
\dontrun{
  raw_data <- import_scn('/home/cwatson/data', atlas='dkt',
                         exclude.subs=c('con07', 'con23', 'pat15'))
}
}
\seealso{
Other Structural covariance network functions: \code{\link{Bootstrapping}},
  \code{\link{IndividualContributions}},
  \code{\link{Residuals}},
  \code{\link{brainGraph_permute}},
  \code{\link{corr.matrix}}, \code{\link{plot_volumetric}}
}
\author{
Christopher G. Watson, \email{cgwatson@bu.edu}
}
\concept{Structural covariance network functions}
