% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bc_list.R
\name{bc.list}
\alias{bc.list}
\alias{bc.list,ANY-method}
\title{Broadcasted Operations for Recursive Arrays}
\usage{
bc.list(x, y, f, ...)

\S4method{bc.list}{ANY}(x, y, f)
}
\arguments{
\item{x, y}{conformable Recursive vectors/arrays (i.e. vectors/arrays of type \code{list}).}

\item{f}{a function that takes in exactly \bold{2} arguments,
and \bold{returns} a result that can be stored in a single element of a list.}

\item{...}{further arguments passed to or from methods. \cr \cr}
}
\value{
A recursive array. \cr \cr
}
\description{
The \code{bc.list()} function performs broadcasted operations on 2 Recursive arrays. \cr
}
\examples{

x.dim <- c(10, 2,2)
x.len <- prod(x.dim)

gen <- function(n) sample(list(letters, month.abb, 1:10), n, TRUE)

x <- array(gen(10), x.dim)
y <- array(gen(10), c(10,1,1))

bc.list(
  x, y,
  \(x, y)c(length(x) == length(y), typeof(x) == typeof(y))
)
}
\seealso{
\link{broadcast_operators} \cr
}
