% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tool-git.R
\name{btw_tool_git_branch_create}
\alias{btw_tool_git_branch_create}
\title{Tool: Git Branch Create}
\usage{
btw_tool_git_branch_create(
  branch,
  ref = "HEAD",
  checkout = TRUE,
  `_intent` = ""
)
}
\arguments{
\item{branch}{Name of the new branch to create.}

\item{ref}{Optional reference point for the new branch. Defaults to \code{"HEAD"}.}

\item{checkout}{Whether to check out the new branch after creation. Defaults
to \code{TRUE}.}

\item{_intent}{An optional string describing the intent of the tool use.
When the tool is used by an LLM, the model will use this argument to
explain why it called the tool.}
}
\value{
Returns a confirmation message.
}
\description{
Allows an LLM to create a new git branch using \code{\link[gert:git_branch]{gert::git_branch_create()}},
equivalent to \verb{git branch <branch>} in the terminal.
}
\examples{
\dontshow{if (rlang::is_installed("gert")) withAutoprint(\{ # examplesIf}
withr::with_tempdir({
  gert::git_init()
  gert::git_config_set("user.name", "R Example")
  gert::git_config_set("user.email", "ex@example.com")

  fs::file_touch("hello.md")
  gert::git_add("hello.md")
  gert::git_commit("Initial commit")

  # LLM creates a new branch
  res <- btw_tool_git_branch_create(branch = "feature/new-analysis")

  # What the LLM sees
  cat(res@value)
})
\dontshow{\}) # examplesIf}
}
\seealso{
Other git tools: 
\code{\link{btw_tool_git_branch_checkout}()},
\code{\link{btw_tool_git_branch_list}()},
\code{\link{btw_tool_git_commit}()},
\code{\link{btw_tool_git_diff}()},
\code{\link{btw_tool_git_log}()},
\code{\link{btw_tool_git_status}()}
}
\concept{git tools}
