% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/citmre.R
\name{rmre_data}
\alias{rmre_data}
\title{rmre_data (Representative Market Rate Exchange) dataset}
\usage{
rmre_data(
  start_date = NULL,
  end_date = NULL,
  log_return = FALSE,
  plot_data = FALSE,
  frequency = 365,
  type = "last_date"
)
}
\arguments{
\item{start_date}{An initial date in the "YYYY-MM-DD" type; by default, the series starts on the first date of the resource}

\item{end_date}{A final date in the "YYYY-MM-DD" form; by default, it shows the updated last date on the resource.}

\item{log_return}{Show the log return of the RMRE (Representative Market Rate Exchange) dataset; if it is TRUE, show the log return dataset; if it is FALSE, show the level dataset; in default, show the level dataset}

\item{plot_data}{Show a Plotly linear graph data set; by default, the argument is false, and the graph is built in the Viewer option. You can use the basic plot if the user does not use the plot_data option.}

\item{frequency}{Show frequencies for the data set in daily (365), month (12), quarter (4), and half-year (2); in default, the dataset is the daily frequency.}

\item{type}{It works only with 12,4,2 frequencies, showing the dataset using the last date ("last_date") or doing a mean ("mean") in the frequency series. By default, the type is "last_date".}
}
\value{
dataset in xts and zoo type
}
\description{
Download the colombian RMRE source: Portal de Datos Abiertos <www.datos.gov.co>
}
\examples{
# Show full series dataset
rmre_serie <- rmre_data()

# Show monthly dataset with Plotly Graph
rmre_splited <- rmre_data(frequency = 12, log_return = F, plot_data = T)

# Show quaterly log_return dataset with Plotly Graph
rmre_splited <- rmre_data(frequency = 4, log_return = T, plot_data = T, type = "mean")

# Show splited log return dataset
rmre_splited <- rmre_data("2000-01-01", "2023-12-31", log_return = TRUE)
}
