% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/meteo_noaa_hourly.R
\name{meteo_noaa_hourly}
\alias{meteo_noaa_hourly}
\title{Hourly NOAA Integrated Surface Hourly (ISH) meteorological data}
\usage{
meteo_noaa_hourly(
  station = NULL,
  year = 2019,
  fm12 = TRUE,
  allow_failure = TRUE
)
}
\arguments{
\item{station}{ID of meteorological station(s) (characters). Find your station's ID at: https://www1.ncdc.noaa.gov/pub/data/noaa/isd-history.txt}

\item{year}{vector of years (e.g., 1966:2000)}

\item{fm12}{use only FM-12 (SYNOP) records (TRUE by default)}

\item{allow_failure}{logical - whether to proceed or stop on failure. By default set to TRUE (i.e. don't stop on error). For debugging purposes change to FALSE}
}
\value{
data.frame with historical meteorological data in hourly intervals
}
\description{
Downloading hourly (meteorological) data from the SYNOP stations available in the NOAA ISD collection.
Some stations in the dataset are dated back even up to 1900.
By default only records that follow FM-12 (SYNOP) convention are processed.
Further details available at: https://www1.ncdc.noaa.gov/pub/data/noaa/readme.txt
}
\examples{
\donttest{
# London-Heathrow, United Kingdom
  noaa = meteo_noaa_hourly(station = "037720-99999", year = 1949)
}
}
