% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gregorian-year-month-weekday.R
\name{year-month-weekday-getters}
\alias{year-month-weekday-getters}
\alias{get_year.clock_year_month_weekday}
\alias{get_month.clock_year_month_weekday}
\alias{get_day.clock_year_month_weekday}
\alias{get_index.clock_year_month_weekday}
\alias{get_hour.clock_year_month_weekday}
\alias{get_minute.clock_year_month_weekday}
\alias{get_second.clock_year_month_weekday}
\alias{get_millisecond.clock_year_month_weekday}
\alias{get_microsecond.clock_year_month_weekday}
\alias{get_nanosecond.clock_year_month_weekday}
\title{Getters: year-month-weekday}
\usage{
\method{get_year}{clock_year_month_weekday}(x)

\method{get_month}{clock_year_month_weekday}(x)

\method{get_day}{clock_year_month_weekday}(x)

\method{get_index}{clock_year_month_weekday}(x)

\method{get_hour}{clock_year_month_weekday}(x)

\method{get_minute}{clock_year_month_weekday}(x)

\method{get_second}{clock_year_month_weekday}(x)

\method{get_millisecond}{clock_year_month_weekday}(x)

\method{get_microsecond}{clock_year_month_weekday}(x)

\method{get_nanosecond}{clock_year_month_weekday}(x)
}
\arguments{
\item{x}{\verb{[clock_year_month_weekday]}

A year-month-weekday to get the component from.}
}
\value{
The component.
}
\description{
These are year-month-weekday methods for the
\link[=clock-getters]{getter generics}.
\itemize{
\item \code{get_year()} returns the Gregorian year.
\item \code{get_month()} returns the month of the year.
\item \code{get_day()} returns the day of the week encoded from 1-7, where 1 = Sunday
and 7 = Saturday.
\item \code{get_index()} returns a value from 1-5 indicating that the corresponding
weekday is the n-th instance of that weekday in the current month.
\item There are sub-daily getters for extracting more precise components.
}
}
\examples{
monday <- clock_weekdays$monday
thursday <- clock_weekdays$thursday

x <- year_month_weekday(2019, 1, monday:thursday, 1:4)
x

# Gets the weekday, 1 = Sunday, 7 = Saturday
get_day(x)

# Gets the index indicating which instance of that particular weekday
# it is in the current month (i.e. the "1st Monday of January, 2019")
get_index(x)
}
