% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/util_expect_scalar.R
\name{util_expect_scalar}
\alias{util_expect_scalar}
\title{check, if a scalar/vector function argument matches expectations}
\usage{
util_expect_scalar(
  arg_name,
  allow_more_than_one = FALSE,
  allow_null = FALSE,
  allow_na = FALSE,
  min_length = -Inf,
  max_length = Inf,
  check_type,
  convert_if_possible,
  conversion_may_replace_NA = FALSE,
  dont_assign = FALSE,
  error_message
)
}
\arguments{
\item{arg_name}{the argument}

\item{allow_more_than_one}{allow vectors}

\item{allow_null}{allow NULL}

\item{allow_na}{allow \code{NAs}}

\item{min_length}{minimum length of the argument's value}

\item{max_length}{maximum length of the argument's value}

\item{check_type}{a predicate function, that must return \code{TRUE} on the
argument's value.}

\item{convert_if_possible}{if given, a lambda can be given
similar to \code{check_type} This
lambda would be used to try a conversion. If
a conversion fails (returns \code{NA}, where the
input was not `util_empty'), an error
is still thrown, the data is converted, otherwise}

\item{conversion_may_replace_NA}{if set to \code{TRUE}, we can define a function
in \code{convert_if_possible} that replaces \code{NA} values without
causing a warning, but this option is set to \code{FALSE} by
default to catch possible conversion problems (use it with
caution).}

\item{dont_assign}{set \code{TRUE} to keep \code{x} in the caller environment untouched}

\item{error_message}{if \code{check_type()} returned \code{FALSE}, show this instead of
a default error message.}
}
\value{
the value of arg_name -- but this is updated in the calling
frame anyway.
}
\description{
check, if a scalar/vector function argument matches expectations
}
\examples{
\dontrun{
f <- function(x) {
  util_expect_scalar(x, check_type = is.integer)
}
f(42L)
try(f(42))
g <- function(x) {
  util_expect_scalar(x, check_type = is.integer, convert_if_possible =
          as.integer)
}
g(42L)
g(42)
}

}
\seealso{
Other robustness_functions: 
\code{\link{util_as_valid_missing_codes}()},
\code{\link{util_check_one_unique_value}()},
\code{\link{util_correct_variable_use}()},
\code{\link{util_empty}()},
\code{\link{util_ensure_character}()},
\code{\link{util_ensure_in}()},
\code{\link{util_ensure_suggested}()},
\code{\link{util_fix_rstudio_bugs}()},
\code{\link{util_is_integer}()},
\code{\link{util_is_numeric_in}()},
\code{\link{util_is_valid_missing_codes}()},
\code{\link{util_match_arg}()},
\code{\link{util_observations_in_subgroups}()},
\code{\link{util_stop_if_not}()},
\code{\link{util_warn_unordered}()}
}
\concept{robustness}
\concept{robustness_functions}
\keyword{internal}
