% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/check_identifiers.R
\name{check_identifiers}
\alias{check_identifiers}
\title{Checks for Differences Between Identifiers in Metadata and DNA Sequence Files}
\usage{
check_identifiers(data, identifier, dna)
}
\arguments{
\item{data}{an object of class \link[tibble:tbl_df-class]{tbl_df} containing sequence metadata.}

\item{identifier}{column in \code{data} which contains sequence identifiers.}

\item{dna}{a \link[ape:DNAbin]{DNAbin} object.}
}
\value{
A list containing erroneus identifiers between metadata and sequence file.
}
\description{
\code{check_identifiers()} checks for differences between identifiers in metadata
and DNA sequence files.
}
\details{
\code{check_identifiers()} is a helper function to check for inconsistencies
between identifiers in metadata and DNA sequences files, such as absence, mistyping,
duplicated entries, or differences in size lengths. If any of these problems are found,
warnings will appear in \code{Console} and corrections should be made to prevent
unintended consequences later. A list containing erroneous identifiers is returned
invisibly.
}
\examples{
check_identifiers(geophagus_info, "gbAccession", geophagus)

}
\author{
Pedro S. Bittencourt, Rupert A. Collins.
}
