# Generated by 02-duckplyr_df-methods.R
#' @export
slice_sample.duckplyr_df <- function(.data, ..., n, prop, by = NULL, weight_by = NULL, replace = FALSE) {
  # Our implementation
  duckplyr_error <- rel_try(NULL,
    "No relational implementation for {.code slice_sample()}" = TRUE,
    {
      return(out)
    }
  )

  # dplyr forward
  check_prudence(.data, duckplyr_error)

  slice_sample <- dplyr$slice_sample.data.frame
  out <- slice_sample(.data, ..., n = n, prop = prop, by = {{ by }}, weight_by = {{ weight_by }}, replace = replace)
  return(out)

  # dplyr implementation
  check_dots_empty0(...)

  size <- get_slice_size(n = n, prop = prop, allow_outsize = replace)

  dplyr_local_error_call()
  dplyr_local_slice_by_arg("by")

  slice(
    .data,
    .by = {{ by }},
    local({
      weight_by <- {{ weight_by }}

      n <- dplyr::n()
      if (!is.null(weight_by)) {
        vec_check_size(weight_by, size = n)
      }
      sample_int(n, size(n), replace = !!replace, wt = weight_by)
    })
  )
}

duckplyr_slice_sample <- function(.data, ...) {
  try_fetch(
    .data <- as_duckplyr_df_impl(.data),
    error = function(e) {
      testthat::skip(conditionMessage(e))
    }
  )
  out <- slice_sample(.data, ...)
  class(out) <- setdiff(class(out), "duckplyr_df")
  out
}
