% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/predict.R
\name{predict.fit_models}
\alias{predict.fit_models}
\title{Predict method for \code{fit_models}}
\usage{
\method{predict}{fit_models}(object, eval_time = NULL, type = c("survival", "hazard"), ...)
}
\arguments{
\item{object}{An object of class \code{fit_models}}

\item{eval_time}{(Optional) A vector of evaluation time points for generating
predictions. Default is \code{NULL}, which if left as NULL, generates a
sequence from 0 to 5 times the maximum observed time.}

\item{type}{A character vector indicating the type of predictions to
generate. Default is \code{c("survival", "hazard")}.}

\item{...}{Additional arguments}
}
\value{
A list of predictions for each model in the
\code{fit_models} object.
}
\description{
Predict method for \code{fit_models}
}
\examples{
models <- fit_models(
  data = easysurv::easy_bc,
  time = "recyrs",
  event = "censrec",
  predict_by = "group",
  covariates = "group"
)

predict(models)
}
