% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/load.R
\name{load_regional_stats}
\alias{load_regional_stats}
\title{Load regional summary statistics}
\usage{
load_regional_stats(species, path = ebirdst_data_dir())
}
\arguments{
\item{species}{character; the species to load data for, given as a scientific
name, common name or six-letter species code (e.g. "woothr"). The full list
of valid species is in the \link{ebirdst_runs} data frame included in this
package. To download the example dataset, use \code{"yebsap-example"}.}

\item{path}{character; directory to download the data to. All downloaded
files will be placed in a sub-directory of this directory named for the
data version year, e.g. "2020" for the 2020 Status Data Products. Each
species' data package will then appear in a directory named with the eBird
species code. Defaults to a persistent data directory, which can be found
by calling \code{ebirdst_data_dir()}.}
}
\value{
A data frame containing regional summary statistics with columns:
\itemize{
\item \code{species_code}: alphanumeric eBird species code.
\item \code{region_type}: \code{country} for countries or \code{state} for states, provinces,
or other sub-national regions.
\item \code{region_code}: alphanumeric code for the region.
\item \code{region_name}: English name of the region.
\item \code{continent_code}: alphanumeric code for continent that this region
belongs to.
\item \code{continent_name}: name of the continent that this region belongs to.
\item \code{season}: name of the season that the summary statistics were calculated
for.
\item \code{abundance_mean}: mean relative abundance in the region.
\item \code{total_pop_percent}: proportion of the seasonal modeled population
falling within the region.
\item \code{range_percent_occupied}: the proportion of the region occupied by the
species during the given season.
\item \code{range_total_percent}: the proportion of the species seasonal range
falling within the region.
\item \code{range_days_occupation}: number of days of the season that the region was
occupied by this species.
}
}
\description{
Load seasonal summary statistics for regions consisting of countries and
states/provinces.
}
\examples{
\dontrun{
# download example data if hasn't already been downloaded
ebirdst_download_status("yebsap-example")

# load configuration parameters
regional <- load_regional_stats("yebsap-example")
}
}
