% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dfcrm_selector.R
\name{get_dfcrm_tite}
\alias{get_dfcrm_tite}
\title{Get an object to fit the TITE-CRM model using the dfcrm package.}
\usage{
get_dfcrm_tite(parent_selector_factory = NULL, skeleton, target, ...)
}
\arguments{
\item{parent_selector_factory}{optional object of type
\code{\link{selector_factory}} that is in charge of dose selection before
this class gets involved. Leave as NULL to just use CRM from the start.}

\item{skeleton}{Dose-toxicity skeleton, a non-decreasing vector of
probabilities.}

\item{target}{We seek a dose with this probability of toxicity.}

\item{...}{Extra args are passed to \code{\link[dfcrm]{crm}}.}
}
\value{
an object of type \code{\link{selector_factory}} that can fit the
CRM model to outcomes.
}
\description{
Get an object to fit the TITE-CRM model using the dfcrm package.
}
\details{
This function is a short-cut to \code{get_dfcrm(tite = TRUE)}. See
\code{\link{get_dfcrm}} for full details.
}
\examples{
skeleton <- c(0.05, 0.1, 0.25, 0.4, 0.6)
target <- 0.25
model1 <- get_dfcrm_tite(skeleton = skeleton, target = target)
outcomes <- data.frame(
  dose = c(1, 1, 2, 2, 3, 3),
  tox = c(0, 0, 0, 0, 1, 0),
  weight = c(1, 1, 1, 0.9, 1, 0.5),
  cohort = c(1, 2, 3, 4, 5, 6)
)
fit <- model1 \%>\% fit(outcomes)

}
\references{
Cheung, K. 2019. dfcrm: Dose-Finding by the Continual Reassessment Method.
R package version 0.2-2.1. https://CRAN.R-project.org/package=dfcrm

Cheung, K. 2011. Dose Finding by the Continual Reassessment Method.
Chapman and Hall/CRC. ISBN 9781420091519
}
