% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/process_model_helpers.R
\name{compute_rmst_difference}
\alias{compute_rmst_difference}
\title{Compute Difference in Restricted Mean Survival Time (RMST)}
\usage{
compute_rmst_difference(
  time_vec,
  status_vec,
  risk_vec,
  tau,
  surv_mat = NULL,
  eval_times_full = NULL,
  model_type = "other"
)
}
\arguments{
\item{time_vec}{Numeric vector of test times.}

\item{status_vec}{Numeric vector of test statuses.}

\item{risk_vec}{Numeric vector of predicted risk scores for test data.}

\item{tau}{The time horizon \eqn{\tau} for integration.}

\item{surv_mat}{Optional. A matrix of individual survival predictions
(rows=subjects, cols=times) used for model-based RMST calculation.}

\item{eval_times_full}{Optional. A numeric vector of time points
corresponding to the columns of \code{surv_mat}.}

\item{model_type}{Optional string (e.log., "rstpm2", "flexsurv") indicating
if a model-based RMST calculation should be attempted.}
}
\value{
The RMST difference (RMST_low - RMST_high), or \code{NA_real_}.
}
\description{
Calculates the difference in RMST between "low" and "high" risk groups up to
a time horizon \eqn{\tau}. Groups are defined by median-splitting the
\code{risk_vec}.
}
\keyword{internal}
