% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/StatMixRHLP.R
\docType{class}
\name{StatMixRHLP-class}
\alias{StatMixRHLP-class}
\alias{StatMixRHLP}
\title{A Reference Class which contains statistics of a mixture of RHLP models.}
\description{
StatMixRHLP contains all the statistics associated to a
\link[=ParamMixRHLP]{MixRHLP} model, in particular the E-Step (and C-Step) of the
(C)EM algorithm.
}
\section{Fields}{

\describe{
\item{\code{pi_jkr}}{Array of size \eqn{(nm, R, K)} representing the logistic
proportion for cluster k.}

\item{\code{tau_ik}}{Matrix of size \eqn{(n, K)} giving the posterior probabilities
(fuzzy segmentation matrix) that the curve \eqn{\boldsymbol{y}_{i}}{y_{i}}
originates from the \eqn{k}-th RHLP model.}

\item{\code{z_ik}}{Hard segmentation logical matrix of dimension \eqn{(n, K)}
obtained by the Maximum a posteriori (MAP) rule: \eqn{z\_ik = 1 \
  \textrm{if} \ z\_i = \textrm{arg} \ \textrm{max}_{k} \ tau\_ik;\ 0 \
  \textrm{otherwise}}{z_ik = 1 if z_i = arg max_k tau_ik; 0 otherwise}.}

\item{\code{klas}}{Column matrix of the labels issued from \code{z_ik}. Its elements are
\eqn{klas[i] = z\_i}{klas[i] = z_i}, \eqn{i = 1,\dots,n}.}

\item{\code{gamma_ijkr}}{Array of size \eqn{(nm, R, K)} giving the posterior
probabilities that the observation \eqn{\boldsymbol{y}_{ij}}{y_{ij}}
originates from the \eqn{r}-th regime of the \eqn{k}-th RHLP model.}

\item{\code{polynomials}}{Array of size \eqn{(m, R, K)} giving the values of the
estimated polynomial regression components.}

\item{\code{weighted_polynomials}}{Array of size \eqn{(m, R, K)} giving the values
of the estimated polynomial regression components weighted by the prior
probabilities \code{pi_jkr}.}

\item{\code{Ey}}{Matrix of size \emph{(m, K)}. \code{Ey} is the curve expectation
(estimated signal): sum of the polynomial components weighted by the
logistic probabilities \code{pi_jkr}.}

\item{\code{loglik}}{Numeric. Observed-data log-likelihood of the MixRHLP model.}

\item{\code{com_loglik}}{Numeric. Complete-data log-likelihood of the MixRHLP model.}

\item{\code{stored_loglik}}{Numeric vector. Stored values of the log-likelihood at
each EM iteration.}

\item{\code{stored_com_loglik}}{Numeric vector. Stored values of the Complete
log-likelihood at each EM iteration.}

\item{\code{BIC}}{Numeric. Value of BIC (Bayesian Information Criterion).}

\item{\code{ICL}}{Numeric. Value of ICL (Integrated Completed Likelihood).}

\item{\code{AIC}}{Numeric. Value of AIC (Akaike Information Criterion).}

\item{\code{log_fk_yij}}{Matrix of size \eqn{(n, K)} giving the values of the
probability density function \eqn{f(\boldsymbol{y}_{i} | z_i = k,
  \boldsymbol{x}, \boldsymbol{\Psi})}{f(y_{i} | z_i = k, x, \Psi)}, \eqn{i =
  1,\dots,n}.}

\item{\code{log_alphak_fk_yij}}{Matrix of size \eqn{(n, K)} giving the values of the
logarithm of the joint probability density function
\eqn{f(\boldsymbol{y}_{i}, \ z_{i} = k | \boldsymbol{x},
  \boldsymbol{\Psi})}{f(y_{i}, z_{i} = k | x, \Psi)}, \eqn{i = 1,\dots,n}.}

\item{\code{log_gamma_ijkr}}{Array of size \eqn{(nm, R, K)} giving the logarithm of
\code{gamma_ijkr}.}
}}

\section{Methods}{

\describe{
\item{\code{computeStats(paramMixRHLP)}}{Method used in the EM algorithm to compute statistics based on
parameters provided by the object \code{paramMixRHLP} of class
\link{ParamMixRHLP}.}

\item{\code{CStep(reg_irls)}}{Method used in the CEM algorithm to update statistics.}

\item{\code{EStep(paramMixRHLP)}}{Method used in the EM algorithm to update statistics based on parameters
provided by the object \code{paramMixRHLP} of class \link{ParamMixRHLP}
(prior and posterior probabilities).}

\item{\code{MAP()}}{MAP calculates values of the fields \code{z_ik} and \code{klas}
      by applying the Maximum A Posteriori Bayes allocation rule.

      \eqn{z\_ik = 1 \ \textrm{if} \ z\_i = \textrm{arg} \
      \textrm{max}_{k} \ tau\_ik;\ 0 \ \textrm{otherwise}
      }{z_ik = 1 if z_i = arg max_k tau_ik; 0 otherwise}.}
}}

\seealso{
\link{ParamMixRHLP}
}
