% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/99_growth_curves.R
\name{fn_exp2_exp}
\alias{fn_exp2_exp}
\title{Super-exponential exponential function}
\usage{
fn_exp2_exp(t, t1, t2, alpha, beta)
}
\arguments{
\item{t}{A numeric vector of input values (e.g., time).}

\item{t1}{The onset time of the response. The function is 0 for all values less than \code{t1}.}

\item{t2}{The transition time between the two exponential phases. Must be greater than \code{t1}.}

\item{alpha}{The curvature-controlled exponential rate during the first phase (\code{t1} to \code{t2}).}

\item{beta}{The exponential growth rate after \code{t2}.}
}
\value{
A numeric vector of the same length as \code{t}, representing the function values.
}
\description{
A piecewise function that models an initial exponential phase with quadratic time dependence,
followed by a second exponential phase with a different growth rate.
}
\details{
\if{html}{
\deqn{
f(t; t_1, t_2, \alpha, \beta) =
\begin{cases}
0 & \text{if } t < t_1 \\
e^{\alpha \cdot (t - t_1)^2} - 1 & \text{if } t_1 \leq t \leq t_2 \\
\left(e^{\alpha \cdot (t_2 - t_1)^2} - 1\right) \cdot e^{\beta \cdot (t - t_2)} & \text{if } t > t_2
\end{cases}
}
}
}
\examples{
library(flexFitR)
plot_fn(
  fn = "fn_exp2_exp",
  params = c(t1 = 35, t2 = 55, alpha = 1 / 600, beta = -1 / 30),
  interval = c(0, 108),
  n_points = 2000,
  auc_label_size = 3,
  y_auc_label = 0.15
)
}
