% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/formods.R
\name{FM_fetch_data_format}
\alias{FM_fetch_data_format}
\title{Creates Formatting Information for Datasets}
\usage{
FM_fetch_data_format(df, state)
}
\arguments{
\item{df}{Raw dataframe to be built into an rhandsontable.}

\item{state}{Current module state after yaml file has been read.}
}
\value{
list with the following elements:
\itemize{
  \item{col_heads:} List (element for each column) of formatting
   information for column  headers to be  use with rhandsontable.
  \item{col_subtext:} List (element for each column) of subtext to
   be displayed in selections using `pickerInput` from the `shinyWidgets` package.
}
}
\description{
Takes a data frame and information in the site configureation
to produce formatting information to make it easier for the user to see data
type information.
}
\examples{
# We need a module state object to use this function:
sess_res = UD_test_mksession()
state = sess_res$state

data_file_local =  system.file(package="formods", "test_data", "TEST_DATA.xlsx")
sheet           = "DATA"

df = readxl::read_excel(path=data_file_local, sheet=sheet)

hfmt = FM_fetch_data_format(df, state)

# Column header formatting
head(as.vector(unlist( hfmt[["col_heads"]])))

# Column select subtext
head(as.vector(unlist( hfmt[["col_subtext"]])))
}
