% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Model.R
\name{Model}
\alias{Model}
\title{Model Class}
\description{
This class implements a model. A \link{Model} object can only exist as element of a
\link{TrainLayer} or a \link{TrainMetaLayer} object. A \link{Model} object is
automatically created by fitting a learner on a training data.

A \link{Model} object can compute predictions for a \link{TestData} object. See the \code{predict} function below.
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-Model-new}{\code{Model$new()}}
\item \href{#method-Model-print}{\code{Model$print()}}
\item \href{#method-Model-summary}{\code{Model$summary()}}
\item \href{#method-Model-getBaseModel}{\code{Model$getBaseModel()}}
\item \href{#method-Model-getTrainData}{\code{Model$getTrainData()}}
\item \href{#method-Model-getTrainLabel}{\code{Model$getTrainLabel()}}
\item \href{#method-Model-getLrner}{\code{Model$getLrner()}}
\item \href{#method-Model-setId}{\code{Model$setId()}}
\item \href{#method-Model-predict}{\code{Model$predict()}}
\item \href{#method-Model-clone}{\code{Model$clone()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Model-new"></a>}}
\if{latex}{\out{\hypertarget{method-Model-new}{}}}
\subsection{Method \code{new()}}{
Constructor of Model class.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Model$new(lrner, train_data, base_model, train_layer)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{lrner}}{\code{Lrner} \cr
The learner.}

\item{\code{train_data}}{\code{TrainData(1)} \cr
Training data.}

\item{\code{base_model}}{\code{object} \cr
Base model as returned by the original learn function.}

\item{\code{train_layer}}{\code{TrainLayer} \cr
The current training layer on which the model is stored.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
An object is returned.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Model-print"></a>}}
\if{latex}{\out{\hypertarget{method-Model-print}{}}}
\subsection{Method \code{print()}}{
Printer
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Model$print(...)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{...}}{\code{any}}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Model-summary"></a>}}
\if{latex}{\out{\hypertarget{method-Model-summary}{}}}
\subsection{Method \code{summary()}}{
Summary
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Model$summary(...)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{...}}{\code{any}}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Model-getBaseModel"></a>}}
\if{latex}{\out{\hypertarget{method-Model-getBaseModel}{}}}
\subsection{Method \code{getBaseModel()}}{
Getter of the base model
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Model$getBaseModel()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Model-getTrainData"></a>}}
\if{latex}{\out{\hypertarget{method-Model-getTrainData}{}}}
\subsection{Method \code{getTrainData()}}{
Getter of the traning data
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Model$getTrainData()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Model-getTrainLabel"></a>}}
\if{latex}{\out{\hypertarget{method-Model-getTrainLabel}{}}}
\subsection{Method \code{getTrainLabel()}}{
Getter of the individual ID column in the training data.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Model$getTrainLabel()}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{...}}{\code{any}}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Model-getLrner"></a>}}
\if{latex}{\out{\hypertarget{method-Model-getLrner}{}}}
\subsection{Method \code{getLrner()}}{
Getter of the learner use to fit the model.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Model$getLrner()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Model-setId"></a>}}
\if{latex}{\out{\hypertarget{method-Model-setId}{}}}
\subsection{Method \code{setId()}}{
Setter of the model ID.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Model$setId(id)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{id}}{\code{character} \cr
ID value}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Model-predict"></a>}}
\if{latex}{\out{\hypertarget{method-Model-predict}{}}}
\subsection{Method \code{predict()}}{
Predict target values for the new data
(from class \link{TestData}) taken as into.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Model$predict(testing_data, use_var_sel, ind_subset = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{testing_data}}{\code{TestData} \cr
An object from class \link{TestData}.}

\item{\code{use_var_sel}}{\code{boolean} \cr
If TRUE, selected variables available at each layer are used.}

\item{\code{ind_subset}}{\code{vector} \cr
Subset of individual IDs to be predicted.}

\item{\code{...}}{Further parameters to be passed to the basic predict function.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
The predicted object are returned. The predicted object must be either a vector or a list
containing a field predictions with predictions.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Model-clone"></a>}}
\if{latex}{\out{\hypertarget{method-Model-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Model$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
