% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/find_peaks.R
\name{thr_peaks}
\alias{thr_peaks}
\title{Threshold Peaks}
\usage{
thr_peaks(TIC_df, THR = 1e+05)
}
\arguments{
\item{TIC_df}{a \emph{data.frame} object. Data frame with 4 columns
(Overall Time Index, RT1, RT2, TIC), ideally the output from create_df(), or
the first data frame returned from extract_data(), $TIC_df.}

\item{THR}{a \emph{float} object. Threshold for peak intensity. Should be a
number between the baseline value and the highest peak intensity. Default
suggestion is THR = 100000.}
}
\value{
A \emph{data.frame} object. A data frame with 4 columns (Time, X, Y,
Peak) with all peaks above the given threshold, with their time coordinates.
}
\description{
\code{thr_peaks} finds all peaks above the given threshold.
}
\details{
This function finds all peaks in the sample above a given intensity
threshold.
}
\examples{
file1 <- system.file("extdata","sample1.cdf",package="gcxgclab")
frame <- extract_data(file1,mod_t=.5)
thrpeaks <- thr_peaks(frame$TIC_df, 100000)
plot_peak(thrpeaks, frame, title="Peaks Above 100,000")
plot_peakonly(thrpeaks,title="Peaks Above 100,000")

}
