% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/geo_model.R
\name{geo_model}
\alias{geo_model}
\title{EStimates the parameters of the exponential model.}
\usage{
geo_model(v_data, m_coord)
}
\arguments{
\item{v_data}{a numeric vector with the data}

\item{m_coord}{a matrix with two column. The first column must be the
latitude and the second column must be the longitude.}
}
\value{
a list with components
\describe{
\item{\code{mean}}{mean of the process}
\item{\code{phi}}{range of exponential model}
\item{\code{sigmasq}}{total sill of exponential model}
\item{\code{convergence}}{convergence as specified in the function
\code{nlminb}}
}
}
\description{
\code{geo_model} finds the maximum likelihood estimate for the parameters
in the geostatistical exponential model.
}
\examples{
data(canada)
v_data <- canada$m_data[1, ]
geo_model(v_data, canada$m_coord)
}
