% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/13-water-quality.R
\name{analyze_water_quality_comprehensive}
\alias{analyze_water_quality_comprehensive}
\title{Analyze water quality comprehensively with flexible data handling}
\usage{
analyze_water_quality_comprehensive(
  water_data,
  variable = NULL,
  region_boundary = NULL,
  river_network = NULL,
  output_folder = tempdir(),
  thresholds = NULL,
  coord_cols = NULL,
  date_column = NULL,
  station_id_col = NULL,
  quality_filters = list(),
  verbose = FALSE
)
}
\arguments{
\item{water_data}{Water quality data in various formats:
\itemize{
\item File path (CSV, shapefile, GeoJSON)
\item data.frame with coordinates
\item sf object
\item List of datasets for multi-dataset analysis
}}

\item{variable}{Variable to analyze (auto-detected if NULL)}

\item{region_boundary}{Region boundary (optional)}

\item{river_network}{Optional river network data for context}

\item{output_folder}{Output directory (default: tempdir())}

\item{thresholds}{Named list of threshold values for classification (optional)}

\item{coord_cols}{Coordinate column names (auto-detected if NULL)}

\item{date_column}{Date/time column name (auto-detected if NULL)}

\item{station_id_col}{Station ID column name (auto-detected if NULL)}

\item{quality_filters}{Quality control filters to apply}

\item{verbose}{Print detailed progress messages}
}
\value{
List with comprehensive water quality analysis results:
\itemize{
\item \code{water_data}: Processed spatial data
\item \code{statistics}: Summary statistics by variable and category
\item \code{spatial_analysis}: Spatial pattern analysis
\item \code{temporal_analysis}: Temporal trends (if date data available)
\item \code{threshold_analysis}: Threshold exceedance analysis
\item \code{output_files}: Paths to generated output files
\item \code{metadata}: Analysis metadata and parameters
}
}
\description{
Complete water quality analysis with flexible data input handling, robust error checking,
and comprehensive spatial integration. Supports any water quality dataset format with
automatic column detection and standardized processing.
}
\examples{
\dontrun{
# These examples require external data files not included with the package
# Flexible data input - auto-detects columns
results <- analyze_water_quality_comprehensive("water_stations.csv")

# Specify parameters for custom data
results <- analyze_water_quality_comprehensive(
  water_data = my_data,
  variable = "nitrate_concentration",
  region_boundary = "Ohio",
  coord_cols = c("longitude", "latitude"),
  thresholds = list(
    Normal = c(0, 2),
    Elevated = c(2, 5),
    High = c(5, 10),
    Critical = c(10, Inf)
  )
)

# Multi-dataset analysis
results <- analyze_water_quality_comprehensive(
  water_data = list(
    surface = "surface_water.csv",
    groundwater = "groundwater.csv"
  ),
  variable = "total_nitrogen"
)
}

}
