% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/distances.R
\name{distance}
\alias{distance}
\title{Calculate distance between 2 points}
\usage{
distance(x, y, ...)
}
\arguments{
\item{x}{an \link{ob_point}, \link{ob_line}, \link{ob_segment}, or object with a center point (e.g., \link{ob_circle}, \link{ob_rectangle}, \link{ob_ellipse})}

\item{y}{an \link{ob_point}, \link{ob_line}, \link{ob_segment}, or object with a center point (e.g., \link{ob_circle}, \link{ob_rectangle}, \link{ob_ellipse})}

\item{...}{<\code{\link[rlang:dyn-dots]{dynamic-dots}}> Not used}
}
\value{
numeric
}
\description{
Calculate distance between 2 points
}
\examples{
# Distance between two objects
p1 <- ob_point(0, 0)
p2 <- ob_point(3, 4)
distance(p1, p2)

# Distance between the endpoints of a segment
s1 <- ob_segment(p1, p2)
distance(s1)

# Distance between a point and a line
l1 <- ob_line(slope = 0, intercept = 1)
distance(p1, l1)

# Shortest distance between the edges of 2 circles
c1 <- ob_circle(p1, radius = 1)
c2 <- ob_circle(p2, radius = 2)
distance(c1, c2)
}
