% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/geom_boundary_cn.R
\name{geom_boundary_cn}
\alias{geom_boundary_cn}
\title{Plot Boundaries of China}
\usage{
geom_boundary_cn(
  crs = "+proj=aeqd +lat_0=35 +lon_0=105 +ellps=WGS84 +units=m +no_defs",
  compass = FALSE,
  scale = FALSE,
  mainland_color = "black",
  mainland_size = 0.5,
  mainland_linetype = "solid",
  coastline_color = "blue",
  coastline_size = 0.3,
  coastline_linetype = "solid",
  ten_segment_line_color = "black",
  ten_segment_line_size = 0.5,
  ten_segment_line_linetype = "solid",
  SAR_boundary_color = "grey",
  SAR_boundary_size = 0.5,
  SAR_boundary_linetype = "dashed",
  undefined_boundary_color = "black",
  undefined_boundary_size = 0.5,
  undefined_boundary_linetype = "longdash",
  province_color = "transparent",
  province_size = 0.3,
  province_linetype = "solid",
  ...
)
}
\arguments{
\item{crs}{Character. Coordinate reference system (CRS) for the projection.
Defaults to `"+proj=aeqd +lat_0=35 +lon_0=105 +ellps=WGS84 +units=m +no_defs"`.
Users can specify other CRS strings to customize the projection (e.g., `"+proj=merc"` for Mercator).}

\item{compass}{Logical. Whether to display a compass (north arrow). Default is `FALSE`.
If set to `TRUE`, a default compass (north arrow) with `ggspatial::north_arrow_fancy_orienteering()`
will be added to the top-left corner. To customize the compass, use `ggspatial::annotation_north_arrow()` directly.}

\item{scale}{Logical. Whether to display a scale bar. Default is `FALSE`.
If set to `TRUE`, a default scale bar with `ggspatial::annotation_scale()` will be added to the bottom-left corner.
To customize the scale bar, use `ggspatial::annotation_scale()` directly.}

\item{mainland_color}{Character. Color for the mainland boundary. Default is `"black"`.}

\item{mainland_size}{Numeric. Line width for the mainland boundary. Default is `0.5`.}

\item{mainland_linetype}{Character. Line type for the mainland boundary. Default is `"solid"`.}

\item{coastline_color}{Character. Color for the coastline. Default is `"blue"`.}

\item{coastline_size}{Numeric. Line width for the coastline. Default is `0.3`.}

\item{coastline_linetype}{Character. Line type for the coastline. Default is `"solid"`.}

\item{ten_segment_line_color}{Character. Color for the ten-segment line. Default is `"black"`.}

\item{ten_segment_line_size}{Numeric. Line width for the ten-segment line. Default is `0.5`.}

\item{ten_segment_line_linetype}{Character. Line type for the ten-segment line. Default is `"solid"`.}

\item{SAR_boundary_color}{Character. Color for the SAR boundary. Default is `"grey"`.}

\item{SAR_boundary_size}{Numeric. Line width for the SAR boundary. Default is `0.5`.}

\item{SAR_boundary_linetype}{Character. Line type for the SAR boundary. Default is `"dashed"`.}

\item{undefined_boundary_color}{Character. Color for the undefined boundary. Default is `"black"`.}

\item{undefined_boundary_size}{Numeric. Line width for the undefined boundary. Default is `0.5`.}

\item{undefined_boundary_linetype}{Character. Line type for the undefined boundary. Default is `"longdash"`.}

\item{province_color}{Character. Color for the provincial boundaries. Default is `"transparent"`.}

\item{province_size}{Numeric. Line width for the provincial boundaries. Default is `0.3`.}

\item{province_linetype}{Character. Line type for the provincial boundaries. Default is `"solid"`.}

\item{...}{Additional parameters passed to `geom_sf`.}
}
\value{
A list of ggplot2 layers representing China's multi-segment boundaries with the specified styles.
  Optionally includes a compass (north arrow) and a scale bar, depending on the `compass` and `scale` arguments.
}
\description{
Draws various types of boundaries for China. Each boundary type can be customized
in terms of color, line width, and line type. This function also allows optional
addition of a compass and a scale bar.
}
\examples{
\donttest{
# Plot China's boundaries with default settings
ggplot() +
  geom_boundary_cn() +
  theme_minimal()

# Plot China's boundaries with a compass and scale bar
ggplot() +
  geom_boundary_cn(compass = TRUE, scale = TRUE) +
  theme_minimal()

# For customized compass or scale bar, use ggspatial directly:
ggplot() +
  geom_boundary_cn() +
  ggspatial::annotation_north_arrow(
    location = "br", style = ggspatial::north_arrow_minimal()
  ) +
  ggspatial::annotation_scale(
    location = "tr", width_hint = 0.3
  ) +
  theme_minimal()
}
}
