% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ggadjust_pvalue.R
\name{ggadjust_pvalue}
\alias{ggadjust_pvalue}
\title{Adjust p-values Displayed on a GGPlot}
\usage{
ggadjust_pvalue(
  p,
  layer = NULL,
  p.adjust.method = "holm",
  label = "p.adj",
  hide.ns = NULL,
  symnum.args = list(),
  output = c("plot", "stat_test")
)
}
\arguments{
\item{p}{a ggplot}

\item{layer}{An integer indicating the statistical layer rank in the ggplot
(in the order added to the plot).}

\item{p.adjust.method}{method for adjusting p values (see
\code{\link[stats]{p.adjust}}).  Has impact only in a situation, where
multiple pairwise tests are performed; or when there are multiple grouping
variables. Ignored when the specified method is \code{"tukey_hsd"} or
\code{"games_howell_test"} because they come with internal p adjustment
method. Allowed values include "holm", "hochberg", "hommel", "bonferroni",
"BH", "BY", "fdr", "none". If you don't want to adjust the p value (not
recommended), use p.adjust.method = "none".}

\item{label}{character string specifying label. Can be: \itemize{ \item the
column containing the label (e.g.: \code{label = "p"} or \code{label =
"p.adj"}), where \code{p} is the p-value. Other possible values are
\code{"p.signif", "p.adj.signif", "p.format", "p.adj.format"}. \item an
expression that can be formatted by the \code{\link[glue]{glue}()} package.
For example, when specifying \code{label = "Wilcoxon, p = \{p\}"}, the
expression \{p\} will be replaced by its value. \item a combination of
plotmath expressions and glue expressions. You may want some of the
statistical parameter in italic; for example:\code{label = "Wilcoxon,
italic(p)= {p}"}}.}

\item{hide.ns}{can be logical value (\code{TRUE} or \code{FALSE}) or a character vector (\code{"p.adj"} or \code{"p"}).}

\item{symnum.args}{a list of arguments to pass to the function
 \code{\link[stats]{symnum}} for symbolic number coding of p-values. For
 example, \code{symnum.args = list(cutpoints = c(0, 0.0001, 0.001, 0.01,
 0.05, Inf), symbols = c("****", "***", "**", "*",  "ns"))}.

 In other words, we use the following convention for symbols indicating
 statistical significance: \itemize{ \item \code{ns}: p > 0.05 \item
 \code{*}: p <= 0.05 \item \code{**}: p <= 0.01 \item \code{***}: p <= 0.001
 \item \code{****}:  p <= 0.0001 }}

\item{output}{character. Possible values are one of \code{c("plot",
"stat_test")}. Default is "plot".}
}
\description{
Adjust p-values produced by \code{\link{geom_pwc}()} on a ggplot.
 This is mainly useful when using facet, where p-values are generally
 computed and adjusted by panel without taking into account the other panels.
 In this case, one might want to adjust after the p-values of all panels together.
}
\examples{
# Data preparation
#:::::::::::::::::::::::::::::::::::::::
df <- ToothGrowth
df$dose <- as.factor(df$dose)
# Add a random grouping variable
df$group <- factor(rep(c("grp1", "grp2"), 30))
head(df, 3)

# Boxplot: Two groups by panel
#:::::::::::::::::::::::::::::::::::::::
# Create a box plot
bxp <- ggboxplot(
  df, x = "supp", y = "len", fill = "#00AFBB",
  facet.by = "dose"
)
# Make facet and add p-values
bxp <- bxp + geom_pwc(method = "t_test")
bxp
# Adjust all p-values together after
ggadjust_pvalue(
  bxp, p.adjust.method = "bonferroni",
  label = "{p.adj.format}{p.adj.signif}", hide.ns = TRUE
)


# Boxplot: Three groups by panel
#:::::::::::::::::::::::::::::::::::::::
# Create a box plot
bxp <- ggboxplot(
  df, x = "dose", y = "len", fill = "#00AFBB",
  facet.by = "supp"
)
# Make facet and add p-values
bxp <- bxp + geom_pwc(method = "t_test")
bxp
# Adjust all p-values together after
ggadjust_pvalue(
  bxp, p.adjust.method = "bonferroni",
  label = "{p.adj.format}{p.adj.signif}"
)
}
