% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/aaa_classes.R, R/treepcor.R
\docType{class}
\name{treepcor-class}
\alias{treepcor-class}
\alias{treepcor}
\alias{print.treepcor}
\alias{summary.treepcor}
\alias{dim.treepcor}
\alias{drop1,treepcor-method}
\alias{edges,treepcor-method}
\alias{plot,treepcor,ANY-method}
\alias{prec.treepcor}
\alias{etreepcor2precision}
\alias{vcov,treepcor-method}
\alias{etreepcor2variance}
\alias{cgeneric.treepcor}
\title{treepcor: correlation from tree}
\usage{
treepcor(...)

\method{print}{treepcor}(x, ...)

\method{summary}{treepcor}(object, ...)

\method{dim}{treepcor}(x, ...)

\S4method{drop1}{treepcor}(object)

\S4method{edges}{treepcor}(object, which, ...)

\S4method{plot}{treepcor,ANY}(x, y, ...)

\method{prec}{treepcor}(model, ...)

etreepcor2precision(d.el)

\S4method{vcov}{treepcor}(object, ...)

etreepcor2variance(d.el)

\method{cgeneric}{treepcor}(model, ...)
}
\arguments{
\item{...}{used to pass \code{theta} as a numeric vector
with the model parameters}

\item{x}{treepcor object}

\item{object}{treepcor}

\item{which}{not used (TO DO: )}

\item{y}{not used}

\item{model}{treepcor}

\item{d.el}{list of the first n edges of a \code{treepcor}.}
}
\value{
a \code{treepcor} object
}
\description{
A tree with two kind of nodes,
parents and children. The parents are nodes with
children. The children are nodes with no children.
This is used to model correlation matrices, where
parents represent latent variables, and children
represent the variables of interest.
}
\details{
In the formula, the left side are parent variables,
and the right side include all the children and
parents that are also children.
The children variables are those with an ancestor (parent),
and are identified as \code{c1}, ..., \code{cn}, where \code{n} is the
total number of children variables.
The parent variables are identified as \code{p1}, ..., \code{pm},
where the \code{m} is the number of parent variables.
The main parent (first) should be identified as \code{p1}.
Except \code{p1} all the other parent variables
have an ancestor, which is a parent variable.
}
\section{Methods (by generic)}{
\itemize{
\item \code{drop1(treepcor)}: The \code{drop1} method for a \code{treepcor}

\item \code{edges(treepcor)}: Extract the edges of a \code{treepcor} to be used for plot

\item \code{plot(x = treepcor, y = ANY)}: The \code{plot} method for a \code{treepcor}

\item \code{vcov(treepcor)}: The \code{vcov} method for a \code{treepcor}

}}
\section{Functions}{
\itemize{
\item \code{treepcor()}: A tree from a formula for each parent.

\item \code{print(treepcor)}: The \code{print} method for a \code{treepcor}

\item \code{summary(treepcor)}: The \code{summary} method for a \code{treepcor}

\item \code{dim(treepcor)}: The \code{dim} for a \code{treepcor}

\item \code{prec(treepcor)}: The \code{prec} for a \code{treepcor}

\item \code{etreepcor2precision()}: Internal function to extract elements to
build the precision from the \code{treepcor} edges.

\item \code{etreepcor2variance()}: Internal function to extract elements to
build the covariance matrix from a \code{treepcor}.

\item \code{cgeneric(treepcor)}: The \code{cgeneric} method for \code{treepcor}, uses \code{\link[=cgeneric_treepcor]{cgeneric_treepcor()}}

}}
\examples{
## for details see
## https://link.springer.com/article/10.1007/s10260-025-00788-y

library(graphpcor)

if(FALSE) {
    
### examples of what is not allowed
    treepcor(p1 ~ p2)
    treepcor(p1 ~ c2)
    
    treepcor(
        p1 ~ c1 + c2,
        p2 ~ c3)
    
    treepcor(
        p1 ~ c1 + c2,
        p2 ~ p1 + c2 + c3)
    
    treepcor(
        p1 ~ c1 + c2,
        p2 ~ p3 + c2 + c3)
    
    treepcor(
        p1 ~ p2 + c1 + c2,
        p2 ~ c2 + c3)

}

### allowed cases

## 3 children and 1 parent
g1 <- treepcor(p1 ~ c1 + c2 - c3)

g1

dim(g1)

summary(g1)

plot(g1)

prec(g1)

(q1 <- prec(g1, theta = c(0)))

v1 <- chol2inv(chol(q1))

v1

cov2cor(v1)

vcov(g1)
vcov(g1, theta = 0)
vcov(g1, theta = -1)
vcov(g1, theta = 1)

cov2cor(vcov(g1))
cov2cor(vcov(g1, theta = -1))
cov2cor(vcov(g1, theta = 1))

## 4 children and 2 parent
g2 <- treepcor(
    p1 ~ p2 + c1 + c2,
    p2 ~ c3 - c4)
g2
dim(g2)
summary(g2)

plot(g2)

prec(g2)
prec(g2, theta = c(0, 0))
prec(g2, theta = c(-1, 1))

cov2cor(solve(prec(g2, theta = c(0,0))))
vcov(g2, theta = c(0,0))
vcov(g2, theta = c(log(4:1), 0,0))

vcov(g2)

g2

## 4 children and 2 parent (notice the signs)
g3 <- treepcor(
    p1 ~ -p2 + c1 + c2,
    p2 ~ -c3 + c4)
g3
dim(g3)
summary(g3)

summary(g2)
summary(g3)

par(mfrow = c(1, 2), mar = c(0,0,0,0))
plot(g2)
plot(g3)

prec(g2)
prec(g3)

prec(g2, theta = c(0, 0))
prec(g3, theta = c(0, 0))

vcov(g2, theta = c(0, 0))
vcov(g3, theta = c(0, 0))

g3


drop1(g2)
drop1(g3) 

prec(g3)
prec(drop1(g3))

n3 <- dim(g3)[1]
all.equal(
    solve(prec(g2, theta = c(0, 0)))[1:n3, 1:n3],
    solve(prec(g3, theta = c(0, 0)))[1:n3, 1:n3]
)

vcov(g2, theta = c(0,0))
vcov(g3, theta = c(0,0))
}
