% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gtsummary_themes.R
\name{gtsummary_themes}
\alias{gtsummary_themes}
\alias{theme_gtsummary_prop_n}
\alias{theme_gtsummary_fisher_simulate_p}
\alias{theme_gtsummary_unweighted_n}
\alias{theme_gtsummary_bold_labels}
\title{Themes for \code{gtsummary}}
\usage{
theme_gtsummary_prop_n(
  prop_stat = "{p}\% ({n})",
  prop_digits = 1,
  mean_sd = FALSE,
  cont_digits = 1,
  set_theme = TRUE
)

theme_gtsummary_fisher_simulate_p(set_theme = TRUE)

theme_gtsummary_unweighted_n(
  n_unweighted_prefix = "",
  n_unweighted_suffix = " obs.",
  prop_digits = 1,
  mean_sd = FALSE,
  cont_digits = 1,
  overall_string = NULL,
  set_theme = TRUE
)

theme_gtsummary_bold_labels(set_theme = TRUE)
}
\arguments{
\item{prop_stat}{(\code{character})\cr
Statistics to display for categorical variables (see
\code{\link[gtsummary:tbl_summary]{gtsummary::tbl_summary()}}).}

\item{prop_digits}{(non-negative \code{integer})\cr
Define the number of decimals to display for proportions.}

\item{mean_sd}{(scalar \code{logical})\cr
Also, set default summary statistics to mean and standard deviation in
\code{\link[gtsummary:tbl_summary]{gtsummary::tbl_summary()}}. Default is \code{FALSE}.}

\item{cont_digits}{(non-negative \code{integer})\cr
Define the number of decimals to display for continuous variables.}

\item{set_theme}{(scalar \code{logical})\cr
Logical indicating whether to set the theme. Default is \code{TRUE}.
When \code{FALSE} the named list of theme elements is returned invisibly}

\item{n_unweighted_prefix, n_unweighted_suffix}{(\code{character})\cr
Prefix and suffix displayed before and after the unweighted number of
observations.}

\item{overall_string}{(\code{character})\cr
Optional string to name the \emph{overall} column.}
}
\description{
Additional themes for tables generated with \code{gtsummary}.
}
\details{
\code{theme_gtsummary_prop_n()} displays, by default, proportions before the
number of observations (between brackets). This function cannot be used
simultaneously with \code{\link[gtsummary:theme_gtsummary]{gtsummary::theme_gtsummary_mean_sd()}}, but you can use
the \code{mean_sd = TRUE} option of \code{theme_gtsummary_prop_n()}.

\code{theme_gtsummary_fisher_simulate_p()} modify the default test used for
categorical variables by Fisher test, with computation of p-values by
Monte Carlo simulation in larger than 2×2 tables.

\code{theme_gtsummary_unweighted_n()} modifies default values of tables returned
by \code{\link[gtsummary:tbl_svysummary]{gtsummary::tbl_svysummary()}} and displays the unweighted number of
observations instead of the weighted n.

\code{theme_gtsummary_bold_labels()} applies automatically
\code{\link[gtsummary:bold_italicize_labels_levels]{gtsummary::bold_labels()}} to all tables generated with \code{gtsummary}.
}
\examples{
\dontshow{if (rlang::is_installed("gtsummary")) withAutoprint(\{ # examplesIf}
\donttest{
library(gtsummary)

trial |>
  tbl_summary(include = c(grade, age), by = trt) |>
  add_p()

theme_gtsummary_prop_n(mean_sd = TRUE)
theme_gtsummary_fisher_simulate_p()
theme_gtsummary_bold_labels()
trial |>
  tbl_summary(include = c(grade, age), by = trt) |>
  add_p()
}
\dontshow{\}) # examplesIf}
\dontshow{if (rlang::is_installed(c("gtsummary", "srvyr"))) withAutoprint(\{ # examplesIf}
\donttest{
data("api", package = "survey")
apistrat$both[1:5] <- NA
apistrat |>
  srvyr::as_survey(strata = stype, weights = pw) |>
  tbl_svysummary(include = c(stype, both), by = awards) |>
  add_overall()

theme_gtsummary_unweighted_n()
apistrat |>
  srvyr::as_survey(strata = stype, weights = pw) |>
  tbl_svysummary(include = c(stype, both), by = awards) |>
  add_overall()
}

gtsummary::reset_gtsummary_theme()
\dontshow{\}) # examplesIf}
}
\keyword{utilities}
