% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/zigzagHMC.R
\name{zigzagHMC}
\alias{zigzagHMC}
\title{Sample from a truncated Gaussian distribution}
\usage{
zigzagHMC(
  nSample,
  burnin = 0,
  mean,
  prec,
  lowerBounds,
  upperBounds,
  init = NULL,
  stepsize = NULL,
  nutsFlg = FALSE,
  precondition = FALSE,
  seed = NULL,
  diagnosticMode = FALSE
)
}
\arguments{
\item{nSample}{number of samples after burn-in.}

\item{burnin}{number of burn-in samples (default = 0).}

\item{mean}{a d-dimensional mean vector.}

\item{prec}{a d-by-d precision matrix of the Gaussian distribution.}

\item{lowerBounds}{a d-dimensional vector specifying the lower bounds. \code{-Inf} is accepted.}

\item{upperBounds}{a d-dimensional vector specifying the upper bounds. \code{Inf} is accepted.}

\item{init}{a d-dimensional vector of the initial value. \code{init} must satisfy all constraints. If \code{init = NULL}, a random initial value will be used.}

\item{stepsize}{step size for Zigzag-HMC or Zigzag-NUTS (if \code{nutsFlg = TRUE}). Default value is the empirically optimal choice: sqrt(2)(lambda)^(-1/2) for Zigzag-HMC and 0.1(lambda)^(-1/2) for Zigzag-NUTS, where lambda is the minimal eigenvalue of the precision matrix.}

\item{nutsFlg}{logical. If \code{TRUE} the No-U-Turn sampler will be used (Zigzag-NUTS).}

\item{precondition}{logical. If \code{TRUE}, the precision matrix will be preconditioned so that its diagonals (i.e. conditional variances) are all 1.}

\item{seed}{random seed (default = 1).}

\item{diagnosticMode}{logical. \code{TRUE} for also returning diagnostic information such as the stepsize used.}
}
\value{
an nSample-by-d matrix of samples. If \code{diagnosticMode} is \code{TRUE}, a list with additional diagnostic information is returned.
}
\description{
Generate MCMC samples from a d-dimensional truncated Gaussian distribution with element-wise truncations using the Zigzag Hamiltonian Monte Carlo sampler (Zigzag-HMC).
}
\examples{
set.seed(1)
d <- 10
A <- matrix(runif(d^2)*2-1, ncol=d)
covMat <- t(A) \%*\% A
precMat <- solve(covMat)
initial <- rep(1, d)
results <- zigzagHMC(nSample = 1000, burnin = 1000, mean = rep(0, d), prec = precMat,
lowerBounds = rep(0, d), upperBounds = rep(Inf, d))

}
\references{
\insertRef{nishimura2024zigzag}{hdtg}

\insertRef{nishimura2020discontinuous}{hdtg}
}
