% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/grid_helpers.R
\name{grid_global}
\alias{grid_global}
\title{Generate a global hexagon grid}
\usage{
grid_global(grid)
}
\arguments{
\item{grid}{A HexGridInfo object specifying the grid parameters}
}
\value{
sf object with hexagon polygons
}
\description{
Creates hexagon polygons covering the entire Earth.
}
\details{
This function generates a complete global grid by sampling points
densely across the globe. For large grids (many small cells),
consider using \code{grid_rect()} to generate regional subsets.
}
\examples{
# Coarse global grid
grid <- hex_grid(area_km2 = 100000)
global <- grid_global(grid)
plot(global)
}
\seealso{
\code{\link{grid_rect}} for regional grids
}
