% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hexify_cell_to_sf.R
\name{hexify_grid_rect}
\alias{hexify_grid_rect}
\title{Generate a rectangular grid of hexagon polygons}
\usage{
hexify_grid_rect(
  minlon,
  maxlon,
  minlat,
  maxlat,
  area,
  aperture = 3L,
  resround = "nearest"
)
}
\arguments{
\item{minlon, maxlon}{Longitude bounds}

\item{minlat, maxlat}{Latitude bounds}

\item{area}{Target cell area in km^2}

\item{aperture}{Grid aperture: 3, 4, or 7}

\item{resround}{Resolution rounding: "nearest", "up", or "down"}
}
\value{
sf object with hexagon polygons covering the specified region
}
\description{
Creates hexagon polygons covering a rectangular geographic region.
}
\examples{
library(hexify)
library(sf)

grid <- hexify_grid_rect(
  minlon = -10, maxlon = 20,
  minlat = 35, maxlat = 60,
  area = 5000
)
plot(st_geometry(grid), border = "gray")
}
\seealso{
\code{\link{grid_rect}} for the recommended S4 interface,
\code{\link{hexify_grid_global}} for global grids

Other sf conversion: 
\code{\link{hex_corners_to_sf}()},
\code{\link{hexify_cell_to_sf}()},
\code{\link{hexify_grid_global}()}
}
\concept{sf conversion}
\keyword{internal}
