% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getCoefVC.twoPhase.R
\name{getCoefVC.twoPhase}
\alias{getCoefVC.twoPhase}
\title{Get Variance Components' Coefficients and Mean Squares for Single-Phase or
Two-Phase Experiments}
\usage{
getCoefVC.twoPhase(
  Pb,
  design.df,
  v.mat,
  response,
  table.legend,
  decimal,
  digits
)
}
\arguments{
\item{Pb}{a list of matrices generated by \code{\link{infoDecompMat}}
function.}

\item{design.df}{a data frame containing the experimental design. Requires
every column be a \code{\link{factor}}.}

\item{v.mat}{a list of matrix generated by \code{\link{getVMat.onePhase}}
or \code{\link{getVMat.twoPhase}}.}

\item{response}{a numeric vector contains the responses from the
experiment.}

\item{table.legend}{a logical allows users to generate a legend for the
variance components of the ANOVA table for large designs. Default is
\code{FALSE}, resulting in the use of original block factor names.}

\item{decimal}{a logical allows users to display the coefficients as the
decimals. Default is \code{FALSE}, resulting in the use of
\code{fractions}.}

\item{digits}{a integer indicating the number of decimal places. Default is
2, resulting in 2 decimal places.}
}
\value{
A matrix containing the characters.
}
\description{
Compute the variance components' coefficients and corresponding to random
effects in the expected mean squares of ANOVA table in single-phase or
two-phase experiments. These coefficients are then inserted to a matrix
where the rows correspond to each source of variation and column correspond
to DF and every variance component. The mean squares is calculated if the
\code{response} argument is used.
}
\details{
The main purpose of this function is to combine the matrices presenting
every source of variation of the ANOVA table and the variance matrix to
compute the coefficients of the variance components.

The complication arise in giving the row names of the matrix for the source
of variation in the ANOVA table.
}
\author{
Kevin Chang
}
