% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/islasso.R
\name{relax.islasso}
\alias{relax.islasso}
\title{Relaxed islasso model fitting}
\usage{
relax.islasso(fit, id = NULL, pval = 0.05, ...)
}
\arguments{
\item{fit}{An object of class \code{islasso}, representing a fitted model.}

\item{id}{Optional. Either:
\itemize{
  \item A numeric vector of indices referring to variables to be kept unpenalized, or
  \item A character vector of variable names to be kept unpenalized.
}
If not provided, selection is based on the significance level given in \code{alpha}.}

\item{pval}{Significance threshold (default \code{0.05}). Variables with p-values
less than or equal to \code{pval} are selected if \code{id} is missing.}

\item{...}{Further arguments passed to \code{update}.}
}
\value{
An object of class \code{islasso}, representing the updated relaxed model.
}
\description{
Fits a relaxed \code{islasso} model by unpenalizing a subset of variables
selected either by statistical significance or by explicit user specification.
}
\details{
The function creates a new \code{islasso} model where the selected variables
are excluded from penalization. Selection can be made either through
explicit variable indices/names via \code{id}, or automatically
by thresholding p-values using \code{alpha}.
}
\examples{
\dontrun{
fit <- islasso(y ~ x1 + x2 + x3, data = dat)
# Relaxed model keeping only variables with p <= 0.01
fit_relaxed <- relax.islasso(fit, alpha = 0.01)

# Relaxed model keeping variable "x1" unpenalized
fit_relaxed2 <- relax.islasso(fit, id = "x1")
}

}
