# Copyright (C) 2020-2023 Koen Derks

# This program is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.

# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.

# You should have received a copy of the GNU General Public License
# along with this program. If not, see <http://www.gnu.org/licenses/>.

#' Factory Workers' use of Hand Sanitizer
#'
#' Data from a study on factory workers' use of hand sanitizer. Sanitizer use
#' was measured to a 100th of a gram.
#'
#' @docType data
#'
#' @usage data(sanitizer)
#'
#' @format A data frame with 1600 rows and 1 variable.
#'
#' @keywords datasets
#'
#' @references [Retracted] Li, M., Sun, Y., & Chen, H. (2019). The decoy effect
#' as a nudge: Boosting hand hygiene with a worse option. Psychological Science,
#' 30, 139–149.
#'
#' @source \url{http://datacolada.org/appendix/74/}
#'
#' @examples
#' data(sanitizer)
"sanitizer"
