% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/jjcsformats.R
\name{count_fraction}
\alias{count_fraction}
\alias{jjcsformat_count_fraction}
\title{Formatting count and fraction values}
\usage{
jjcsformat_count_fraction(x, d = 1, roundmethod = c("sas", "iec"), ...)
}
\arguments{
\item{x}{\code{numeric}\cr with elements \code{num} and \code{fraction} or \code{num}, \code{denom} and \code{fraction}.}

\item{d}{numeric(1). Number of digits to round fraction to (default=1)}

\item{roundmethod}{(\code{string})\cr choice of rounding methods. Options are:
\itemize{
\item \code{sas}: the underlying rounding method is \code{tidytlg::roundSAS}, where \cr
roundSAS comes from this Stack Overflow post https://stackoverflow.com/questions/12688717/round-up-from-5
\item \code{iec}: the underlying rounding method is \code{round}
}}

\item{...}{Additional arguments passed to other methods.}
}
\value{
A string in the format \verb{count / denom (ratio percent)}. If \code{count}
is 0, the format is \code{0}. If fraction is >0.99, the format is
\verb{count / denom (>99.9 percent)}
}
\description{
Formats a count together with fraction (and/or denominator) with special
consideration when count is 0, or fraction is 1.
\cr See also: tern::format_count_fraction_fixed_dp()
}
\examples{
jjcsformat_count_fraction(c(7, 0.7))
jjcsformat_count_fraction(c(70000, 0.9999999))
jjcsformat_count_fraction(c(70000, 1))

}
\seealso{
Other JJCS formats: 
\code{\link{format_xx_fct}()},
\code{\link{jjcsformat_pval_fct}()},
\code{\link{jjcsformat_range_fct}()}
}
\concept{JJCS formats}
