% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/metrics.R
\name{metric_sensitivity_at_specificity}
\alias{metric_sensitivity_at_specificity}
\title{Computes best sensitivity where specificity is >= specified value.}
\usage{
metric_sensitivity_at_specificity(
  ...,
  specificity,
  num_thresholds = 200L,
  class_id = NULL,
  name = NULL,
  dtype = NULL
)
}
\arguments{
\item{...}{For forward/backward compatability.}

\item{specificity}{A scalar value in range \verb{[0, 1]}.}

\item{num_thresholds}{(Optional) Defaults to 200. The number of thresholds to
use for matching the given specificity.}

\item{class_id}{(Optional) Integer class ID for which we want binary metrics.
This must be in the half-open interval \verb{[0, num_classes)}, where
\code{num_classes} is the last dimension of predictions.}

\item{name}{(Optional) string name of the metric instance.}

\item{dtype}{(Optional) data type of the metric result.}
}
\value{
a \code{Metric} instance is returned. The \code{Metric} instance can be passed
directly to \code{compile(metrics = )}, or used as a standalone object. See
\code{?Metric} for example usage.
}
\description{
\code{Sensitivity} measures the proportion of actual positives that are correctly
identified as such \code{(tp / (tp + fn))}.
\code{Specificity} measures the proportion of actual negatives that are correctly
identified as such \code{(tn / (tn + fp))}.

This metric creates four local variables, \code{true_positives},
\code{true_negatives}, \code{false_positives} and \code{false_negatives} that are used to
compute the sensitivity at the given specificity. The threshold for the
given specificity value is computed and used to evaluate the corresponding
sensitivity.

If \code{sample_weight} is \code{NULL}, weights default to 1.
Use \code{sample_weight} of 0 to mask values.

If \code{class_id} is specified, we calculate precision by considering only the
entries in the batch for which \code{class_id} is above the threshold
predictions, and computing the fraction of them for which \code{class_id} is
indeed a correct label.

For additional information about specificity and sensitivity, see
\href{https://en.wikipedia.org/wiki/Sensitivity_and_specificity}{the following}.
}
\section{Usage}{
Standalone usage:

\if{html}{\out{<div class="sourceCode r">}}\preformatted{m <- metric_sensitivity_at_specificity(specificity = 0.5)
m$update_state(c(0,   0,   0,   1,   1),
               c(0, 0.3, 0.8, 0.3, 0.8))
m$result()
}\if{html}{\out{</div>}}

\if{html}{\out{<div class="sourceCode">}}\preformatted{## tf.Tensor(0.5, shape=(), dtype=float32)

}\if{html}{\out{</div>}}

\if{html}{\out{<div class="sourceCode r">}}\preformatted{m$reset_state()
m$update_state(c(0,   0,   0,   1,   1),
               c(0, 0.3, 0.8, 0.3, 0.8),
               sample_weight = c(1, 1, 2, 2, 1))
m$result()
}\if{html}{\out{</div>}}

\if{html}{\out{<div class="sourceCode">}}\preformatted{## tf.Tensor(0.33333334, shape=(), dtype=float32)

}\if{html}{\out{</div>}}

Usage with \code{compile()} API:

\if{html}{\out{<div class="sourceCode r">}}\preformatted{model |> compile(
  optimizer = 'sgd',
  loss = 'binary_crossentropy',
  metrics = list(metric_sensitivity_at_specificity())
)
}\if{html}{\out{</div>}}
}

\seealso{
\itemize{
\item \url{https://keras.io/api/metrics/classification_metrics#sensitivityatspecificity-class}
}

Other confusion metrics: \cr
\code{\link{metric_auc}()} \cr
\code{\link{metric_false_negatives}()} \cr
\code{\link{metric_false_positives}()} \cr
\code{\link{metric_precision}()} \cr
\code{\link{metric_precision_at_recall}()} \cr
\code{\link{metric_recall}()} \cr
\code{\link{metric_recall_at_precision}()} \cr
\code{\link{metric_specificity_at_sensitivity}()} \cr
\code{\link{metric_true_negatives}()} \cr
\code{\link{metric_true_positives}()} \cr

Other metrics: \cr
\code{\link{Metric}()} \cr
\code{\link{custom_metric}()} \cr
\code{\link{metric_auc}()} \cr
\code{\link{metric_binary_accuracy}()} \cr
\code{\link{metric_binary_crossentropy}()} \cr
\code{\link{metric_binary_focal_crossentropy}()} \cr
\code{\link{metric_binary_iou}()} \cr
\code{\link{metric_categorical_accuracy}()} \cr
\code{\link{metric_categorical_crossentropy}()} \cr
\code{\link{metric_categorical_focal_crossentropy}()} \cr
\code{\link{metric_categorical_hinge}()} \cr
\code{\link{metric_concordance_correlation}()} \cr
\code{\link{metric_cosine_similarity}()} \cr
\code{\link{metric_f1_score}()} \cr
\code{\link{metric_false_negatives}()} \cr
\code{\link{metric_false_positives}()} \cr
\code{\link{metric_fbeta_score}()} \cr
\code{\link{metric_hinge}()} \cr
\code{\link{metric_huber}()} \cr
\code{\link{metric_iou}()} \cr
\code{\link{metric_kl_divergence}()} \cr
\code{\link{metric_log_cosh}()} \cr
\code{\link{metric_log_cosh_error}()} \cr
\code{\link{metric_mean}()} \cr
\code{\link{metric_mean_absolute_error}()} \cr
\code{\link{metric_mean_absolute_percentage_error}()} \cr
\code{\link{metric_mean_iou}()} \cr
\code{\link{metric_mean_squared_error}()} \cr
\code{\link{metric_mean_squared_logarithmic_error}()} \cr
\code{\link{metric_mean_wrapper}()} \cr
\code{\link{metric_one_hot_iou}()} \cr
\code{\link{metric_one_hot_mean_iou}()} \cr
\code{\link{metric_pearson_correlation}()} \cr
\code{\link{metric_poisson}()} \cr
\code{\link{metric_precision}()} \cr
\code{\link{metric_precision_at_recall}()} \cr
\code{\link{metric_r2_score}()} \cr
\code{\link{metric_recall}()} \cr
\code{\link{metric_recall_at_precision}()} \cr
\code{\link{metric_root_mean_squared_error}()} \cr
\code{\link{metric_sparse_categorical_accuracy}()} \cr
\code{\link{metric_sparse_categorical_crossentropy}()} \cr
\code{\link{metric_sparse_top_k_categorical_accuracy}()} \cr
\code{\link{metric_specificity_at_sensitivity}()} \cr
\code{\link{metric_squared_hinge}()} \cr
\code{\link{metric_sum}()} \cr
\code{\link{metric_top_k_categorical_accuracy}()} \cr
\code{\link{metric_true_negatives}()} \cr
\code{\link{metric_true_positives}()} \cr
}
\concept{confusion metrics}
\concept{metrics}
