% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fixed_regex_linter.R
\name{fixed_regex_linter}
\alias{fixed_regex_linter}
\title{Require usage of \code{fixed=TRUE} in regular expressions where appropriate}
\usage{
fixed_regex_linter(allow_unescaped = FALSE)
}
\arguments{
\item{allow_unescaped}{Logical, default \code{FALSE}. If \code{TRUE}, only patterns that
require regex escapes (e.g. \code{"\\\\$"} or \code{"[$]"}) will be linted. See examples.}
}
\description{
Invoking a regular expression engine is overkill for cases when the search
pattern only involves static patterns.
}
\details{
NB: for \code{stringr} functions, that means wrapping the pattern in \code{stringr::fixed()}.

NB: this linter is likely not able to distinguish every possible case when
a fixed regular expression is preferable, rather it seeks to identify
likely cases. It should \emph{never} report false positives, however; please
report false positives as an error.
}
\examples{
# will produce lints
code_lines <- 'gsub("\\\\\\\\.", "", x)'
writeLines(code_lines)
lint(
  text = code_lines,
  linters = fixed_regex_linter()
)

lint(
  text = 'grepl("a[*]b", x)',
  linters = fixed_regex_linter()
)

lint(
  text = 'grepl("a[*]b", x)',
  linters = fixed_regex_linter(allow_unescaped = TRUE)
)

code_lines <- 'stringr::str_subset(x, "\\\\\\\\$")'
writeLines(code_lines)
lint(
  text = code_lines,
  linters = fixed_regex_linter()
)

lint(
  text = 'grepl("Munich", address)',
  linters = fixed_regex_linter()
)

# okay
code_lines <- 'gsub("\\\\\\\\.", "", x, fixed = TRUE)'
writeLines(code_lines)
lint(
  text = code_lines,
  linters = fixed_regex_linter()
)

lint(
  text = 'grepl("a*b", x, fixed = TRUE)',
  linters = fixed_regex_linter()
)

lint(
  text = 'stringr::str_subset(x, stringr::fixed("$"))',
  linters = fixed_regex_linter()
)

lint(
  text = 'grepl("Munich", address, fixed = TRUE)',
  linters = fixed_regex_linter()
)

lint(
  text = 'grepl("Munich", address)',
  linters = fixed_regex_linter(allow_unescaped = TRUE)
)

}
\seealso{
\link{linters} for a complete list of linters available in lintr.
}
\section{Tags}{
\link[=best_practices_linters]{best_practices}, \link[=configurable_linters]{configurable}, \link[=efficiency_linters]{efficiency}, \link[=readability_linters]{readability}, \link[=regex_linters]{regex}
}
