% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fuse.R
\name{timing_data}
\alias{timing_data}
\title{Get the timing data of code chunks and text blocks in a document}
\usage{
timing_data(threshold = 0, sort = TRUE, total = TRUE)
}
\arguments{
\item{threshold}{A number (time in seconds) to subset data with. Only rows
with time above this threshold are returned.}

\item{sort}{Whether to sort the data by time in the decreasing order.}

\item{total}{Whether to append the total time to the data.}
}
\value{
A data frame containing input file paths, line numbers, chunk labels,
and time. If no timing data is available, \code{NULL} is returned.
}
\description{
Timing can be enabled via the chunk option \code{time = TRUE} (e.g., set
\link{reactor}\code{(time = TRUE)} in the first code chunk). After it is
enabled, the execution time for code chunks and text blocks will be recorded.
This function can be called to retrieve the timing data later in the document
(e.g., in the last code chunk).
}
\note{
By default, the data will be cleared after each call of \code{\link[=fuse]{fuse()}} and
will not be available outside \code{\link[=fuse]{fuse()}}. To store the data persistently, you
can set the \code{time} option to a file path. This is necessary if you want to
get the timing data for multiple input documents (such as all chapters of a
book). Each document needs to point the \code{time} option to the same path.
When you do not need timing any more, you will need to delete this file by
yourself.
}
