% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/distributions.R
\name{dextgp}
\alias{dextgp}
\alias{hextgp}
\alias{qextgp}
\title{Density function of the extended generalized Pareto distribution}
\usage{
dextgp(x, scale = 1, shape1 = 0, shape2 = 0, log = FALSE)

hextgp(x, scale = 1, shape1 = 0, shape2 = 0, log = FALSE)

qextgp(p, scale = 1, shape1 = 0, shape2 = 0, lower.tail = TRUE)
}
\arguments{
\item{x}{vector of quantiles.}

\item{scale}{scale parameter, strictly positive.}

\item{shape1}{positive shape parameter \eqn{\beta}; model defaults to generalized Pareto when it equals zero.}

\item{shape2}{shape parameter \eqn{\gamma}; model reduces to Gompertz when \code{shape2=0}.}

\item{log}{logical; if \code{TRUE}, return the log hazard}

\item{p}{vector of probabilities.}

\item{lower.tail}{logical; if \code{TRUE} (default), the lower tail probability \eqn{\Pr(X \leq x)} is returned.}
}
\value{
a vector of (log)-density of the same length as \code{x}

a vector of (log)-hazard of the same length as \code{x}

a vector of quantiles
}
\description{
Density function of the extended generalized Pareto distribution

Hazard function of the extended generalized Pareto distribution

Quantile function of the extended generalized Pareto distribution
}
\keyword{internal}
