% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/autoplot_lookout.R
\name{autoplot.lookoutliers}
\alias{autoplot.lookoutliers}
\title{Plots outliers identified by lookout algorithm.}
\usage{
\method{autoplot}{lookoutliers}(object, columns = 1:2, ...)
}
\arguments{
\item{object}{The output of the function `lookout`.}

\item{columns}{Which columns of the original data to plot
(specified as either numbers or strings)}

\item{...}{Other arguments currently ignored.}
}
\value{
A ggplot object.
}
\description{
Scatterplot of two columns from the data set with outliers highlighted.
}
\examples{
X <- rbind(
  data.frame(x = rnorm(500),
             y = rnorm(500)),
  data.frame(x = rnorm(5, mean = 10, sd = 0.2),
             y = rnorm(5, mean = 10, sd = 0.2))
)
lo <- lookout(X)
autoplot(lo)
}
