% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lsirm2pl_mar_ss.R
\name{lsirm2pl_mar_ss}
\alias{lsirm2pl_mar_ss}
\title{2PL LSIRM with model selection approach for missing at random data.}
\usage{
lsirm2pl_mar_ss(
  data,
  ndim = 2,
  niter = 15000,
  nburn = 2500,
  nthin = 5,
  nprint = 500,
  jump_beta = 0.4,
  jump_theta = 1,
  jump_alpha = 1,
  jump_gamma = 1,
  jump_z = 0.5,
  jump_w = 0.5,
  pr_mean_beta = 0,
  pr_sd_beta = 1,
  pr_mean_theta = 0,
  pr_sd_theta = 1,
  pr_spike_mean = -3,
  pr_spike_sd = 1,
  pr_slab_mean = 0.5,
  pr_slab_sd = 1,
  pr_mean_alpha = 0.5,
  pr_sd_alpha = 1,
  pr_a_theta = 0.001,
  pr_b_theta = 0.001,
  pr_xi_a = 1,
  pr_xi_b = 1,
  missing.val = 99,
  verbose = FALSE,
  fix_theta_sd = FALSE,
  fix_alpha_1 = TRUE
)
}
\arguments{
\item{data}{Matrix; a binary or continuous item response matrix for analysis. Each row represents a respondent, and each column contains responses to the corresponding item.}

\item{ndim}{Integer; the dimension of the latent space. Default is 2.}

\item{niter}{Integer; the total number of MCMC iterations to run. Default is 15000.}

\item{nburn}{Integer; the number of initial MCMC iterations to discard as burn-in. Default is 2500.}

\item{nthin}{Integer; the number of MCMC iterations to thin. Default is 5.}

\item{nprint}{Integer; the interval at which MCMC samples are displayed during execution. Default is 500.}

\item{jump_beta}{Numeric; the jumping rule for the beta proposal density. Default is 0.4.}

\item{jump_theta}{Numeric; the jumping rule for the theta proposal density. Default is 1.0.}

\item{jump_alpha}{Numeric; the jumping rule for the alpha proposal density. Default is 1.0.}

\item{jump_gamma}{Numeric; the jumping rule for the theta proposal density. Default is 1.0.}

\item{jump_z}{Numeric; the jumping rule for the z proposal density. Default is 0.5.}

\item{jump_w}{Numeric; the jumping rule for the w proposal density. Default is 0.5.}

\item{pr_mean_beta}{Numeric; the mean of the normal prior for beta. Default is 0.}

\item{pr_sd_beta}{Numeric; the standard deviation of the normal prior for beta. Default is 1.0.}

\item{pr_mean_theta}{Numeric; the mean of the normal prior for theta. Default is 0.}

\item{pr_sd_theta}{Numeric; the standard deviation of the normal prior for theta. Default is 1.0.}

\item{pr_spike_mean}{Numeric; the mean of spike prior for log gamma. Default is -3.}

\item{pr_spike_sd}{Numeric; the standard deviation of spike prior for log gamma. Default is 1.}

\item{pr_slab_mean}{Numeric; the mean of spike prior for log gamma. Default is 0.5.}

\item{pr_slab_sd}{Numeric; the standard deviation of spike prior for log gamma. Default is is 1.}

\item{pr_mean_alpha}{Numeric; the mean of the log normal prior for alpha. Default is 0.5.}

\item{pr_sd_alpha}{Numeric; the standard deviation of the log normal prior for alpha. Default is 1.0.}

\item{pr_a_theta}{Numeric; the shape parameter of the inverse gamma prior for the variance of theta. Default is 0.001.}

\item{pr_b_theta}{Numeric; the scale parameter of the inverse gamma prior for the variance of theta. Default is 0.001.}

\item{pr_xi_a}{Numeric; the first shape parameter of beta prior for latent variable xi. Default is 1.}

\item{pr_xi_b}{Numeric; the second shape parameter of beta prior for latent variable xi. Default is 1.}

\item{missing.val}{Numeric; a number to replace missing values. Default is 99.}

\item{verbose}{Logical; If TRUE, MCMC samples are printed for each \code{nprint}. Default is FALSE.}

\item{fix_theta_sd}{Logical; If TRUE, the standard deviation of the theta parameter is fixed. Default is FALSE.}

\item{fix_alpha_1}{Logical; If TRUE, the first element of the alpha parameter is fixed to 1. Default is TRUE.}
}
\value{
\code{lsirm2pl_mar_ss} returns an object of  list containing the following components:
 \item{data}{Data frame or matrix containing the variables in the model.}
 \item{missing.val}{A number to replace missing values.}
 \item{bic}{Numeric value with the corresponding BIC.}
\item{mcmc_inf}{Details about the number of MCMC iterations, burn-in periods, and thinning intervals.}
\item{map_inf}{The log maximum a posteriori (MAP) value and the iteration number at which this MAP value occurs.}
\item{beta_estimate}{Posterior estimates of the beta parameter.}
\item{theta_estimate}{Posterior estimates of the theta parameter.}
\item{sigma_theta_estimate}{Posterior estimates of the standard deviation of theta.}
\item{gamma_estimate}{posterior estimates of gamma parameter.}
\item{z_estimate}{Posterior estimates of the z parameter.}
\item{w_estimate}{Posterior estimates of the w parameter.}
\item{z_raw}{Posterior samples of the z parameter without procrustes matching.}
\item{w_raw}{Posterior samples of the w parameter without procrustes matching.}
\item{beta}{Posterior samples of the beta parameter.}
\item{theta}{Posterior samples of the theta parameter.}
\item{gamma}{Posterior samples of the gamma parameter.}
\item{theta_sd}{Posterior samples of the standard deviation of theta.}
\item{z}{Posterior samples of the z parameter, represented as a 3-dimensional matrix where the last axis denotes the dimension of the latent space.}
\item{w}{Posterior samples of the w parameter, represented as a 3-dimensional matrix where the last axis denotes the dimension of the latent space.}
\item{pi}{Posterior samples of phi which is indicator of spike and slab prior. If phi is 1, log gamma follows the slab prior, otherwise follows the spike prior. }
 \item{imp}{Imputation for missing Values using posterior samples.}
\item{accept_beta}{Acceptance ratio for the beta parameter.}
\item{accept_theta}{Acceptance ratio for the theta parameter.}
\item{accept_z}{Acceptance ratio for the z parameter.}
\item{accept_w}{Acceptance ratio for the w parameter.}
\item{accept_gamma}{Acceptance ratio for the gamma parameter.}
 \item{pi_estimate}{Posterior estimation of phi. inclusion probability of gamma. if estimation of phi is less than 0.5, choose Rasch model with gamma = 0, otherwise latent space model with gamma > 0. }
 \item{imp_estimate}{Probability of imputating a missing value with 1.}
 \item{alpha_estimate}{Posterior estimates of the alpha parameter.}
 \item{alpha}{Posterior estimates of the alpha parameter.}
 \item{accept_alpha}{Acceptance ratio for the alpha parameter.}
}
\description{
\link{lsirm2pl_mar_ss} is used to fit 2PL LSIRM based on spike-and-slab priors in incomplete data assumed to be missing at random.
\link{lsirm2pl_mar_ss} factorizes item response matrix into column-wise item effect, row-wise respondent effect in a latent space, while considering the missing element under the assumption of missing at random. Unlike 1PL model, 2PL model assumes the item effect can vary according to respondent, allowing additional parameter multiplied with respondent effect.  The resulting latent space provides an interaction map that represents interactions between respondents and items.
}
\details{
\code{lsirm2pl_mar_ss} models the probability of correct response by respondent \eqn{j} to item \eqn{i} with item effect \eqn{\beta_i}, respondent effect \eqn{\theta_j}  in the shared metric space, with \eqn{\gamma} represents the weight of the distance term. For 2pl model, the the item effect is assumed to have additional discrimination parameter \eqn{\alpha_i} multiplied by \eqn{\theta_j}: \deqn{logit(P(Y_{j,i} = 1|\theta_j,\alpha_i,\beta_i,\gamma,z_j,w_i))=\theta_j*\alpha_i+\beta_i-\gamma||z_j-w_i||}Under the assumption of missing at random, the model takes the missing element into consideration in the sampling procedure. For the details of missing at random assumption and data augmentation, see References. \code{lsirm2pl_mar_ss} model include model selection approach based on spike-and-slab priors for log gamma. For detail of spike-and-slab priors, see References.
}
\examples{
\donttest{
# generate example item response matrix
data     <- matrix(rbinom(500, size = 1, prob = 0.5), ncol=10, nrow=50)

# generate example missing indicator matrix
missing_mat     <- matrix(rbinom(500, size = 1, prob = 0.2), ncol=10, nrow=50)

# make missing value with missing indicator matrix
data[missing_mat==1] <- 99

lsirm_result <- lsirm2pl_mar_ss(data)

# The code following can achieve the same result.
lsirm_result <- lsirm(data ~ lsirm2pl(spikenslab = TRUE, fixed_gamma = FALSE,
                      missing_data = "mar"))
}
}
\references{
Little, R. J., & Rubin, D. B. (2019). Statistical analysis with missing data (Vol. 793). John Wiley & Sons.
Ishwaran, H., & Rao, J. S. (2005). Spike and slab variable selection: Frequentist and Bayesian strategies. The Annals of Statistics, 33(2), 730-773.
}
