% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/neModel.R
\name{expData-methods}
\alias{expData-methods}
\alias{residuals.expData}
\alias{residualPlot.expData}
\alias{residualPlots.expData}
\alias{weights.expData}
\title{Methods for expanded datasets}
\usage{
\method{residuals}{expData}(object, ...)

\method{residualPlot}{expData}(model, ...)

\method{residualPlots}{expData}(model, ...)

\method{weights}{expData}(object, ...)
}
\arguments{
\item{object}{an expanded dataset (of class \code{"\link{expData}"}).}

\item{...}{additional arguments.}

\item{model}{an expanded dataset (of class \code{"\link{expData}"}) (for use with \code{residualPlot} and \code{residualPlots}).}
}
\description{
Regression weights, residuals and residual plots for expanded datasets.
}
\details{
\code{weights} extracts regression weights (to be used in the natural effect model) for each observation of an expanded dataset.

\code{residuals} extracts residuals from the working model which is stored as an attribute of the expanded dataset. These can be used to assess normality of the residuals of the mediator working model when using the weighting-based approach (see example).

\code{residualPlot} and \code{residualPlots} are convenience functions from the \pkg{car} package. These can be used to assess the adequacy of the working model.
}
\examples{
data(UPBdata)

weightData <- neWeight(negaff ~ att + gender + educ + age, 
                       data = UPBdata, nRep = 2)

## extract regression weights for natural effect model
head(weights(weightData)) 

## assess normality
qqnorm(residuals(weightData))

## assess model adequacy
library(car)
residualPlots(weightData)
}
\seealso{
\code{\link{expData}}, \code{\link{neWeight}}, \code{\link[car]{residualPlot}}, \code{\link[car]{residualPlots}}, \code{\link{residuals}}, \code{\link{weights}}
}
