% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/filters.R
\name{filter_mz}
\alias{filter_mz}
\title{Filter Features based on their mass-to-charge ratios}
\usage{
filter_mz(data, m_z_col, masses, tolerance = 5, tolerance_type = "ppm")
}
\arguments{
\item{data}{A tidy tibble created by \code{\link[metamorphr]{read_featuretable}}.}

\item{m_z_col}{Which column holds the precursor m/z (or exact mass)? Uses \code{\link[rlang]{args_data_masking}}.}

\item{masses}{The mass(es) to filter by.}

\item{tolerance}{A numeric. The tolerance to apply to the masses Either an absolute value in Da (if \code{tolerance_type = "absolute"}) or in ppm (if \code{tolerance_type = "ppm"}).}

\item{tolerance_type}{Either \code{"absolute"} or \code{"ppm"}. Should the tolerance be an absolute value or in ppm?}
}
\value{
A filtered tibble.
}
\description{
Facilitates filtering by given mass-to-charge ratios (m/z) with a defined tolerance. Can also be used to filter based on exact mass.
}
\examples{
# Use a tolerance of plus or minus 5 ppm
toy_metaboscape \%>\%
  filter_mz(m_z_col = `m/z`, 162.1132, tolerance = 5, tolerance_type = "ppm")

# Use a tolerance of plus or minus 0.005 Da
toy_metaboscape \%>\%
  filter_mz(m_z_col = `m/z`, 162.1132, tolerance = 0.005, tolerance_type = "absolute")
}
