% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/protdatasim.R
\name{protdatasim}
\alias{protdatasim}
\title{Data simulation function}
\usage{
protdatasim(
  iii = 1,
  nobs = 200,
  nobs1 = 10,
  ng1 = 5,
  ng2 = 5,
  mg1 = 100,
  mg2 = 200,
  dispg1 = 1,
  dispg2 = 1
)
}
\arguments{
\item{iii}{A parameter useful to loop over for simulated lists of datasets. It has no effect.}

\item{nobs}{Number of peptides}

\item{nobs1}{Number of peptides with differential expressions between the two conditions}

\item{ng1}{Number of biological replicates in condition A}

\item{ng2}{Number of biological replicates in condition B}

\item{mg1}{Mean in condition A}

\item{mg2}{Mean in condition B}

\item{dispg1}{Dispersion in condition A}

\item{dispg2}{Dispersion in condition B}
}
\value{
A data frame with the simulated and attribute metadata.
}
\description{
Function to simulate benchmark datasets.
}
\examples{
data_sim <- protdatasim()
attr(data_sim,"metadata")

norm.200.m100.sd1.vs.m200.sd1_list <- lapply(1:100, protdatasim)
attr(norm.200.m100.sd1.vs.m200.sd1_list[[1]],"metadata")

}
\references{
M. Chion, Ch. Carapito and F. Bertrand (2021). \emph{Accounting for multiple imputation-induced variability for differential analysis in mass spectrometry-based label-free quantitative proteomics}.  \doi{doi:10.1371/journal.pcbi.1010420}.
}
