% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/join_mirtarbase.R
\name{join_mirtarbase}
\alias{join_mirtarbase}
\title{Add miRNA targets from miRTarBase version 8.0}
\usage{
join_mirtarbase(
  df,
  col.pmid.df = PMID,
  col.topic.df = NULL,
  filter_na = TRUE,
  reduce = FALSE
)
}
\arguments{
\item{df}{Data frame containing PubMed-IDs
that the miRNA targets shall be joined to.}

\item{col.pmid.df}{Symbol. Column containing PubMed-IDs in \code{df}.}

\item{col.topic.df}{Symbol. Optional. Only important if \code{reduce = TRUE}.
If given, adds a topic column to the reduced data.frame.}

\item{filter_na}{Boolean. If \code{filter_na = TRUE}, drops all rows containing
\code{NA} in column \code{Target}.}

\item{reduce}{Boolean. If \code{reduce = FALSE}, adds a new column containing miRNA
targets to \code{df}.
If \code{reduce = TRUE}, adds two new
columns containing miRNA names and miRNA targets to \code{df}. All
other columns except for the PubMed-ID column and (optionally) the
topic column are dropped.}
}
\value{
Data frame containing miRNA targets.
}
\description{
Add miRNA targets from miRTarBase version 8.0 to a data frame.
}
\details{
Add miRNA targets from miRTarBase version 8.0 to a data frame.
\code{join_mirtarbase()} can return two different data frames, regulated by \code{reduce}:
\enumerate{
\item If \code{reduce = FALSE}, \code{join_mirtarbase()} adds targets from miRTarBase 8.0
to the data frame in a new column. These targets then correspond
to the targets determined in the research paper, but do not necessarily correspond
to the miRNA names mentioned in the abstract.
\item If \code{reduce = TRUE}, \code{join_mirtarbase()} adds targets from
miRTarBase 8.0 to the data frame in a new column. However, an
altered data frame is returned, containing the PubMed-IDs, targets, and
miRNAs from miRTarBase 8.0.
}

miRTarBase was published in

Hsi-Yuan Huang, Yang-Chi-Dung Lin, Jing Li, et al.,
miRTarBase 2020: updates to the experimentally validated microRNA–target
interaction database, Nucleic Acids Research, Volume 48, Issue D1,
08 January 2020, Pages D148–D154, https://doi.org/10.1093/nar/gkz896
}
\seealso{
Other target functions: 
\code{\link{count_target}()},
\code{\link{join_targets}()},
\code{\link{plot_target_count}()},
\code{\link{plot_target_mir_scatter}()}
}
\concept{target functions}
