% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/preprocess.R
\name{get_caret_dummyvars_df}
\alias{get_caret_dummyvars_df}
\title{Get dummyvars dataframe (i.e. design matrix)}
\usage{
get_caret_dummyvars_df(features, full_rank = FALSE, progbar = NULL)
}
\arguments{
\item{features}{dataframe of features for machine learning}

\item{full_rank}{whether matrix should be full rank or not (see `\link[caret:dummyVars]{caret::dummyVars})}

\item{progbar}{optional progress bar (default: \code{NULL})}
}
\value{
design matrix
}
\description{
Get dummyvars dataframe (i.e. design matrix)
}
\examples{
\dontrun{
df <- data.frame(
  outcome = c("normal", "normal", "cancer"),
  var1 = 1:3,
  var2 = c("a", "b", "c"),
  var3 = c("no", "yes", "no"),
  var4 = c(0, 1, 0)
)
get_caret_dummyvars_df(df, TRUE)
}
}
\author{
Zena Lapp, \email{zenalapp@umich.edu}
}
\keyword{internal}
