% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/db-create.R
\name{gdb.create_genome}
\alias{gdb.create_genome}
\title{Create and Load a Genome Database}
\usage{
gdb.create_genome(genome, path = getwd(), tmpdir = tempdir())
}
\arguments{
\item{genome}{A character string specifying the genome to download. Supported genomes are "mm9", "mm10", "mm39", "hg19", and "hg38".}

\item{path}{A character string specifying the directory where the genome will be extracted. Defaults to genome name (e.g. "mm10") in the current working directory.}

\item{tmpdir}{A character string specifying the directory for storing temporary files. This is used for storing the downloaded genome file.}
}
\value{
None.
}
\description{
This function downloads, extracts, and loads a misha genome database for the specified genome.
}
\details{
The function checks if the specified genome is available. If tmpdir, it constructs the download URL, downloads the genome file,
extracts it to the specified directory, and loads the genome database using \code{gsetroot}. The function also calls \code{gdb.reload} to reload the genome database.
}
\examples{
\donttest{
mm10_dir <- tempdir()
gdb.create_genome("mm10", path = mm10_dir)
list.files(file.path(mm10_dir, "mm10"))
gsetroot(file.path(mm10_dir, "mm10"))
gintervals.ls()
}

}
